# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['PostingObligations']


class PostingObligations(BaseDataClass):
    """
    A class to specify the collateral posting obligations of the security provider or security providers as specified in the corresponding agreement.
    """
    securityProvider: str = Field(..., description="The security provider party(ies) to which the posting obligations apply to, which can be either one of the parties to the legal agreement, or both of those.")
    """
    The security provider party(ies) to which the posting obligations apply to, which can be either one of the parties to the legal agreement, or both of those.
    """
    partyElection: List[cdm.legaldocumentation.csa.PostingObligationsElection.PostingObligationsElection] = Field([], description="The specification of the collateral posting obligations for the security provider party(ies).")
    """
    The specification of the collateral posting obligations for the security provider party(ies).
    """
    @rosetta_condition
    def cardinality_partyElection(self):
        return check_cardinality(self.partyElection, 1, None)
    

import cdm 
import cdm.legaldocumentation.csa.PostingObligationsElection
