# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['PostedCreditSupportItem']


class PostedCreditSupportItem(BaseDataClass):
    """
    Posted Credit Support item with corresponding Valuation Percentage, FX Haircut Percentage and any related disputed Posted Credit Support valuation.
    """
    cashOrSecurityValue: cdm.observable.asset.Money.Money = Field(..., description="The Base Currency Equivalent of Cash or Security.")
    """
    The Base Currency Equivalent of Cash or Security.
    """
    haircutPercentage: Decimal = Field(..., description="Valuation Percentage means, for any item of Eligible Collateral (IM), the percentage specified in accordance with Paragraph 13.")
    """
    Valuation Percentage means, for any item of Eligible Collateral (IM), the percentage specified in accordance with Paragraph 13.
    """
    fxHaircutPercentage: Optional[Decimal] = Field(None, description="FX Haircut Percentage means, for any item of Eligible Collateral (IM), the percentage specified in accordance with Paragraph 13.")
    """
    FX Haircut Percentage means, for any item of Eligible Collateral (IM), the percentage specified in accordance with Paragraph 13.
    """
    additionalHaircutPercentage: Optional[Decimal] = Field(None, description="Percentage value of any additional haircut to be applied to a collateral asset,the percentage value is expressed as the discount haircut to the value of the collateral- as an example a 5% haircut would be expressed as 0.05.")
    """
    Percentage value of any additional haircut to be applied to a collateral asset,the percentage value is expressed as the discount haircut to the value of the collateral- as an example a 5% haircut would be expressed as 0.05.
    """
    disputedCashOrSecurityValue: cdm.observable.asset.Money.Money = Field(..., description="Paragraph 5. If a party (a 'Disputing Party') disputes the Value of any Posted Credit Support (IM).")
    """
    Paragraph 5. If a party (a 'Disputing Party') disputes the Value of any Posted Credit Support (IM).
    """

import cdm 
import cdm.observable.asset.Money
