# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['LegacyConsentEnum']

class LegacyConsentEnum(Enum):
    """
    Details of the consent requirements (if any) for Substitution.
    """
    CONSENT_REQUIRED = "ConsentRequired"
    """
    Consent is required for Substitution.
    """
    CONSENT_REQUIRED_NO_DELAY = "ConsentRequiredNoDelay"
    """
    Consent is required, with no unreasonable delay, for Substitution.
    """
    COSTS_APPORTIONED = "CostsApportioned"
    """
    Costs apportioned for Substitution.
    """
    NO_CONSENT = "NoConsent"
    """
    No consent is required for Substitution.
    """
    NOTICE_CONDITIONS = "NoticeConditions"
    """
    Notice conditions apply for Substitution.
    """
    TIMES_ADJUSTED = "TimesAdjusted"
    """
    Times adjusted.
    """
