# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['JurisdictionRelatedTerms']


class JurisdictionRelatedTerms(BaseDataClass):
    """
    A class to specify terms jurisdiction related terms.
    """
    japaneseSecuritiesProvisions: Optional[cdm.legaldocumentation.csa.JapaneseSecuritiesProvisions.JapaneseSecuritiesProvisions] = Field(None, description="The Japanese Securities Provisions election.")
    """
    The Japanese Securities Provisions election.
    """
    exclusiveJurisdiction: Optional[bool] = Field(None, description="Classification of optional exclusive jurisdiction terms.")
    """
    Classification of optional exclusive jurisdiction terms.
    """
    juryWaiver: Optional[bool] = Field(None, description="The Jury Waiver conditions specific to the agreement.")
    """
    The Jury Waiver conditions specific to the agreement.
    """
    frenchLawAddendum: Optional[cdm.legaldocumentation.csa.FrenchLawAddendum.FrenchLawAddendum] = Field(None, description="The French Law Addendum Provisions specific to the agreement.")
    """
    The French Law Addendum Provisions specific to the agreement.
    """
    belgianLawSecurityAgreement: Optional[bool] = Field(None, description="The qualification of whether the Belgian Law Security Agreement Addendum is deemed applicable by the parties (True) or not (False).")
    """
    The qualification of whether the Belgian Law Security Agreement Addendum is deemed applicable by the parties (True) or not (False).
    """

import cdm 
import cdm.legaldocumentation.csa.JapaneseSecuritiesProvisions
import cdm.legaldocumentation.csa.FrenchLawAddendum
