# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['JapaneseSecuritiesProvisions']


class JapaneseSecuritiesProvisions(BaseDataClass):
    """
    A class to specify Japanese Securities Provision elections.
    """
    isApplicable: bool = Field(..., description="Japanese Securities Provisions are applicable when True and Not Applicable when False.")
    """
    Japanese Securities Provisions are applicable when True and Not Applicable when False.
    """
    relevantProvisionsElection: Optional[bool] = Field(None, description="Recommended Japanese Securities Provisions are applicable when True, additional Provisions are specified when False.")
    """
    Recommended Japanese Securities Provisions are applicable when True, additional Provisions are specified when False.
    """
    relevantProvisionsTerms: Optional[str] = Field(None, description="Specific terms applicable to Recommended Japanese Securities Provisions.")
    """
    Specific terms applicable to Recommended Japanese Securities Provisions.
    """
    amendmentsToJapaneseProvisions: Optional[bool] = Field(None, description="Additional Amendments to Japanese Securities Provisions are specified when True, and not specified when False.")
    """
    Additional Amendments to Japanese Securities Provisions are specified when True, and not specified when False.
    """
    amendmentsToJapaneseProvisionsTerms: Optional[str] = Field(None, description="Specific terms applicable to Additional Amendments to Japanese Securities Provisions.")
    """
    Specific terms applicable to Additional Amendments to Japanese Securities Provisions.
    """
    clearstreamAmendmentToJapaneseProvisions: Optional[bool] = Field(None, description="Specification of whether Clearstream Event amendment language is included (true) or excluded (false).")
    """
    Specification of whether Clearstream Event amendment language is included (true) or excluded (false).
    """
    
    @rosetta_condition
    def condition_0_RelevantProvisionsElection(self):
        """
        A data rule to enforce that the specific terms applicable to Recommended Japanese Securities Provisions should be specified when required.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "relevantProvisionsTerms")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "relevantProvisionsElection"), "=", True), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_AmendmentsToJapaneseProvisions(self):
        """
        A data rule to enforce that the specific terms applicable to Additional Amendments to Japanese Securities Provisions should be specified when required.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "amendmentsToJapaneseProvisionsTerms")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "amendmentsToJapaneseProvisions"), "=", False), _then_fn0, _else_fn0)

import cdm 
