# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['DisputeResolution']


class DisputeResolution(BaseDataClass):
    """
    A class to specify the election terms under which a party disputes the Value of any Transfer of Eligible Credit Support or Posted Credit Support.
    """
    resolutionTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="The time by which the dispute needs to be resolved, failure of which would trigger a recalculation alongside a process that is specified as part of the agreement.")
    """
    The time by which the dispute needs to be resolved, failure of which would trigger a recalculation alongside a process that is specified as part of the agreement.
    """
    otherTerms: Optional[str] = Field(None, description="The custom Resolution Time election that might be specified by the parties.")
    """
    The custom Resolution Time election that might be specified by the parties.
    """
    valueTerms: str = Field(..., description="The method of calculation for determining value for the purposes of a Variation Margin agreement.")
    """
    The method of calculation for determining value for the purposes of a Variation Margin agreement.
    """
    alternativeTerms: Optional[str] = Field(None, description="The alternative dispute resolution procedure if specified.")
    """
    The alternative dispute resolution procedure if specified.
    """
    recalculationOfValue: Optional[cdm.legaldocumentation.csa.RecalculationOfValue.RecalculationOfValue] = Field(None, description="The elections to specify terms for recalculation of the market value of posted collateral.")
    """
    The elections to specify terms for recalculation of the market value of posted collateral.
    """
    legacyResolutionTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="Definition of a point of time un the following LBD to the date of notice in the resolution process at which the recalculation of the disputed amount(s) begins if the consultation process has not resolved the dispute.")
    """
    Definition of a point of time un the following LBD to the date of notice in the resolution process at which the recalculation of the disputed amount(s) begins if the consultation process has not resolved the dispute.
    """
    legacyAlternative: Optional[cdm.legaldocumentation.csa.LegacyResolutionAlternative.LegacyResolutionAlternative] = Field(None, description="Alternative procedures to those in the pre-print for resolving collateral related disputes.")
    """
    Alternative procedures to those in the pre-print for resolving collateral related disputes.
    """
    legacyValue: Optional[cdm.legaldocumentation.csa.LegacyResolutionValue.LegacyResolutionValue] = Field(None, description="Methodology for resolving disputes in respect of the determination of the value of collateral.")
    """
    Methodology for resolving disputes in respect of the determination of the value of collateral.
    """

import cdm 
import cdm.base.datetime.BusinessCenterTime
import cdm.legaldocumentation.csa.RecalculationOfValue
import cdm.legaldocumentation.csa.LegacyResolutionAlternative
import cdm.legaldocumentation.csa.LegacyResolutionValue
