# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CustodyArrangements']


class CustodyArrangements(BaseDataClass):
    """
    A class to specify the Custody Arrangements for the agreement.
    """
    isCreditSupportDocument: Optional[bool] = Field(None, description="Unless specified as True, the Control Agreement is not a Credit Support Document under the agreement with respect to a party.")
    """
    Unless specified as True, the Control Agreement is not a Credit Support Document under the agreement with respect to a party.
    """
    hasControlAgreementLanguage: Optional[bool] = Field(None, description="Control Agreement language is specified when True.")
    """
    Control Agreement language is specified when True.
    """
    otherProvisions: Optional[str] = Field(None, description="Other Custom Provisions of Custody Arrangements.")
    """
    Other Custom Provisions of Custody Arrangements.
    """
    collateralAccessBreach: Optional[cdm.legaldocumentation.csa.CollateralAccessBreach.CollateralAccessBreach] = Field(None, description="The elections specific to Collateral Access Breach language.")
    """
    The elections specific to Collateral Access Breach language.
    """
    custodianRisk: Optional[cdm.legaldocumentation.csa.CustodianRisk.CustodianRisk] = Field(None, description="The qualification of the Custodian Risk.")
    """
    The qualification of the Custodian Risk.
    """
    controlAgreement: Optional[cdm.legaldocumentation.csa.ControlAgreement.ControlAgreement] = Field(None, description="The party-specific election with respect to the control agreement.")
    """
    The party-specific election with respect to the control agreement.
    """
    custodianEvent: cdm.legaldocumentation.csa.CustodianEvent.CustodianEvent = Field(..., description="Specifies if and until when a Custodian Event clause applies.")
    """
    Specifies if and until when a Custodian Event clause applies.
    """
    custodian: Optional[cdm.legaldocumentation.csa.Custodian.Custodian] = Field(None, description="The custodian and segregated account details for each party to the agreement.")
    """
    The custodian and segregated account details for each party to the agreement.
    """
    collateralManagementAgreement: Optional[cdm.legaldocumentation.csa.CollateralManagementAgreement.CollateralManagementAgreement] = Field(None, description="")

import cdm 
import cdm.legaldocumentation.csa.CollateralAccessBreach
import cdm.legaldocumentation.csa.CustodianRisk
import cdm.legaldocumentation.csa.ControlAgreement
import cdm.legaldocumentation.csa.CustodianEvent
import cdm.legaldocumentation.csa.Custodian
import cdm.legaldocumentation.csa.CollateralManagementAgreement
