# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CreditSupportProvider']


class CreditSupportProvider(BaseDataClass):
    """
    Identification of party specific Credit Support Providers applicable to the document.
    """
    creditSupportProviderElection: List[cdm.legaldocumentation.csa.CreditSupportProviderElection.CreditSupportProviderElection] = Field([], description="The party election of Credit Support Provider(s), if any.")
    """
    The party election of Credit Support Provider(s), if any.
    """
    @rosetta_condition
    def cardinality_creditSupportProviderElection(self):
        return check_cardinality(self.creditSupportProviderElection, 2, None)
    

import cdm 
import cdm.legaldocumentation.csa.CreditSupportProviderElection
