# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['CashCTSTimeEnum']

class CashCTSTimeEnum(Enum):
    """
    Details the day on which cash collateral is required to be transferred relative to the Notification Time.
    """
    FIRST_LBD = "First Local Business Day"
    """
    The cash collateral should be transferred on the first local business day.
    """
    NEXT = "Next"
    """
    The cash collateral should be transferred on the next day.
    """
    OTHER = "Other"
    """
    Exception value.
    """
    SAME = "Same"
    """
    The cash collateral should be transferred on the same day.
    """
    SECOND_LBD = "Second Local Business Day"
    """
    The cash collateral should be transferred on the second local business day.
    """
