# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CSAThresholdVariableSet']


class CSAThresholdVariableSet(BaseDataClass):
    """
    Defines a combination of Rating Agency, Rating Value, Threshold amount and Currency code.
    """
    name: Optional[cdm.observable.asset.CreditRatingAgencyEnum.CreditRatingAgencyEnum] = Field(None, description="The relevant rating agency.")
    """
    The relevant rating agency.
    """
    value: Optional[str] = Field(None, description="Rating applicable to the party from a given rating agency.")
    """
    Rating applicable to the party from a given rating agency.
    """
    amount: Optional[int] = Field(None, description="The amount value applicable to the Threshold.")
    """
    The amount value applicable to the Threshold.
    """
    
    @rosetta_condition
    def condition_0_NameMustExist(self):
        """
        If we have a name then we must also have a value.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "value"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "name")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_ValueMustExist(self):
        """
        If we have a value then we must also have a name.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "name"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "value")), _then_fn0, _else_fn0)

import cdm 
import cdm.observable.asset.CreditRatingAgencyEnum
