/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDates;
import cdm.base.datetime.BusinessCenterTime;
import cdm.product.template.ExerciseFee;
import cdm.product.template.ExerciseFeeSchedule;
import cdm.product.template.ExerciseProcedure;
import cdm.product.template.ExpirationTimeTypeEnum;
import cdm.product.template.MultipleExercise;
import cdm.product.template.OptionExerciseStyleEnum;
import cdm.product.template.PartialExercise;
import cdm.product.template.meta.ExerciseTermsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExerciseTerms", builder=ExerciseTermsBuilderImpl.class, version="6.10.0")
@RuneDataType(value="ExerciseTerms", model="cdm", builder=ExerciseTermsBuilderImpl.class, version="6.10.0")
public interface ExerciseTerms
extends RosettaModelObject,
GlobalKey {
    public static final ExerciseTermsMeta metaData = new ExerciseTermsMeta();

    public OptionExerciseStyleEnum getStyle();

    public AdjustableOrRelativeDate getCommencementDate();

    public AdjustableOrRelativeDates getExerciseDates();

    public List<? extends AdjustableOrRelativeDate> getExpirationDate();

    public AdjustableOrRelativeDates getRelevantUnderlyingDate();

    public BusinessCenterTime getEarliestExerciseTime();

    public BusinessCenterTime getLatestExerciseTime();

    public BusinessCenterTime getExpirationTime();

    public ExpirationTimeTypeEnum getExpirationTimeType();

    public MultipleExercise getMultipleExercise();

    public ExerciseFeeSchedule getExerciseFeeSchedule();

    public ExerciseProcedure getExerciseProcedure();

    public ExerciseFee getExerciseFee();

    public PartialExercise getPartialExercise();

    public MetaFields getMeta();

    public ExerciseTerms build();

    public ExerciseTermsBuilder toBuilder();

    public static ExerciseTermsBuilder builder() {
        return new ExerciseTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends ExerciseTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExerciseTerms> getType() {
        return ExerciseTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("style"), OptionExerciseStyleEnum.class, (Object)this.getStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commencementDate"), processor, AdjustableOrRelativeDate.class, this.getCommencementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseDates"), processor, AdjustableOrRelativeDates.class, this.getExerciseDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relevantUnderlyingDate"), processor, AdjustableOrRelativeDates.class, this.getRelevantUnderlyingDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earliestExerciseTime"), processor, BusinessCenterTime.class, this.getEarliestExerciseTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("latestExerciseTime"), processor, BusinessCenterTime.class, this.getLatestExerciseTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationTime"), processor, BusinessCenterTime.class, this.getExpirationTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationTimeType"), ExpirationTimeTypeEnum.class, (Object)this.getExpirationTimeType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("multipleExercise"), processor, MultipleExercise.class, this.getMultipleExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseFeeSchedule"), processor, ExerciseFeeSchedule.class, this.getExerciseFeeSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseFee"), processor, ExerciseFee.class, this.getExerciseFee(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partialExercise"), processor, PartialExercise.class, this.getPartialExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class ExerciseTermsBuilderImpl
    implements ExerciseTermsBuilder {
        protected OptionExerciseStyleEnum style;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder commencementDate;
        protected AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder exerciseDates;
        protected List<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> expirationDate = new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>();
        protected AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder relevantUnderlyingDate;
        protected BusinessCenterTime.BusinessCenterTimeBuilder earliestExerciseTime;
        protected BusinessCenterTime.BusinessCenterTimeBuilder latestExerciseTime;
        protected BusinessCenterTime.BusinessCenterTimeBuilder expirationTime;
        protected ExpirationTimeTypeEnum expirationTimeType;
        protected MultipleExercise.MultipleExerciseBuilder multipleExercise;
        protected ExerciseFeeSchedule.ExerciseFeeScheduleBuilder exerciseFeeSchedule;
        protected ExerciseProcedure.ExerciseProcedureBuilder exerciseProcedure;
        protected ExerciseFee.ExerciseFeeBuilder exerciseFee;
        protected PartialExercise.PartialExerciseBuilder partialExercise;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="style")
        @RuneAttribute(value="style")
        public OptionExerciseStyleEnum getStyle() {
            return this.style;
        }

        @Override
        @RosettaAttribute(value="commencementDate")
        @RuneAttribute(value="commencementDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getCommencementDate() {
            return this.commencementDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateCommencementDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.commencementDate != null ? this.commencementDate : (this.commencementDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseDates")
        @RuneAttribute(value="exerciseDates")
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getExerciseDates() {
            return this.exerciseDates;
        }

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateExerciseDates() {
            AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder result = this.exerciseDates != null ? this.exerciseDates : (this.exerciseDates = AdjustableOrRelativeDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public List<? extends AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate(int index) {
            if (this.expirationDate == null) {
                this.expirationDate = new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>();
            }
            return (AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder)this.getIndex(this.expirationDate, index, () -> {
                AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder newExpirationDate = AdjustableOrRelativeDate.builder();
                return newExpirationDate;
            });
        }

        @Override
        @RosettaAttribute(value="relevantUnderlyingDate")
        @RuneAttribute(value="relevantUnderlyingDate")
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getRelevantUnderlyingDate() {
            return this.relevantUnderlyingDate;
        }

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateRelevantUnderlyingDate() {
            AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder result = this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate : (this.relevantUnderlyingDate = AdjustableOrRelativeDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseTime")
        @RuneAttribute(value="earliestExerciseTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestExerciseTime() {
            return this.earliestExerciseTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestExerciseTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.earliestExerciseTime != null ? this.earliestExerciseTime : (this.earliestExerciseTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTime")
        @RuneAttribute(value="latestExerciseTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getLatestExerciseTime() {
            return this.latestExerciseTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateLatestExerciseTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.latestExerciseTime != null ? this.latestExerciseTime : (this.latestExerciseTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationTime")
        @RuneAttribute(value="expirationTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpirationTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.expirationTime != null ? this.expirationTime : (this.expirationTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationTimeType", isRequired=true)
        @RuneAttribute(value="expirationTimeType", isRequired=true)
        public ExpirationTimeTypeEnum getExpirationTimeType() {
            return this.expirationTimeType;
        }

        @Override
        @RosettaAttribute(value="multipleExercise")
        @RuneAttribute(value="multipleExercise")
        public MultipleExercise.MultipleExerciseBuilder getMultipleExercise() {
            return this.multipleExercise;
        }

        @Override
        public MultipleExercise.MultipleExerciseBuilder getOrCreateMultipleExercise() {
            MultipleExercise.MultipleExerciseBuilder result = this.multipleExercise != null ? this.multipleExercise : (this.multipleExercise = MultipleExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseFeeSchedule")
        @RuneAttribute(value="exerciseFeeSchedule")
        public ExerciseFeeSchedule.ExerciseFeeScheduleBuilder getExerciseFeeSchedule() {
            return this.exerciseFeeSchedule;
        }

        @Override
        public ExerciseFeeSchedule.ExerciseFeeScheduleBuilder getOrCreateExerciseFeeSchedule() {
            ExerciseFeeSchedule.ExerciseFeeScheduleBuilder result = this.exerciseFeeSchedule != null ? this.exerciseFeeSchedule : (this.exerciseFeeSchedule = ExerciseFeeSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure() {
            ExerciseProcedure.ExerciseProcedureBuilder result = this.exerciseProcedure != null ? this.exerciseProcedure : (this.exerciseProcedure = ExerciseProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseFee")
        @RuneAttribute(value="exerciseFee")
        public ExerciseFee.ExerciseFeeBuilder getExerciseFee() {
            return this.exerciseFee;
        }

        @Override
        public ExerciseFee.ExerciseFeeBuilder getOrCreateExerciseFee() {
            ExerciseFee.ExerciseFeeBuilder result = this.exerciseFee != null ? this.exerciseFee : (this.exerciseFee = ExerciseFee.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partialExercise")
        @RuneAttribute(value="partialExercise")
        public PartialExercise.PartialExerciseBuilder getPartialExercise() {
            return this.partialExercise;
        }

        @Override
        public PartialExercise.PartialExerciseBuilder getOrCreatePartialExercise() {
            PartialExercise.PartialExerciseBuilder result = this.partialExercise != null ? this.partialExercise : (this.partialExercise = PartialExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="style")
        @RuneAttribute(value="style")
        public ExerciseTermsBuilder setStyle(OptionExerciseStyleEnum _style) {
            this.style = _style == null ? null : _style;
            return this;
        }

        @Override
        @RosettaAttribute(value="commencementDate")
        @RuneAttribute(value="commencementDate")
        public ExerciseTermsBuilder setCommencementDate(AdjustableOrRelativeDate _commencementDate) {
            this.commencementDate = _commencementDate == null ? null : _commencementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseDates")
        @RuneAttribute(value="exerciseDates")
        public ExerciseTermsBuilder setExerciseDates(AdjustableOrRelativeDates _exerciseDates) {
            this.exerciseDates = _exerciseDates == null ? null : _exerciseDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public ExerciseTermsBuilder addExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            if (_expirationDate != null) {
                this.expirationDate.add(_expirationDate.toBuilder());
            }
            return this;
        }

        @Override
        public ExerciseTermsBuilder addExpirationDate(AdjustableOrRelativeDate _expirationDate, int idx) {
            this.getIndex(this.expirationDate, idx, () -> _expirationDate.toBuilder());
            return this;
        }

        @Override
        public ExerciseTermsBuilder addExpirationDate(List<? extends AdjustableOrRelativeDate> expirationDates) {
            if (expirationDates != null) {
                for (AdjustableOrRelativeDate adjustableOrRelativeDate : expirationDates) {
                    this.expirationDate.add(adjustableOrRelativeDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="expirationDate")
        public ExerciseTermsBuilder setExpirationDate(List<? extends AdjustableOrRelativeDate> expirationDates) {
            this.expirationDate = expirationDates == null ? new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>() : (List)expirationDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="relevantUnderlyingDate")
        @RuneAttribute(value="relevantUnderlyingDate")
        public ExerciseTermsBuilder setRelevantUnderlyingDate(AdjustableOrRelativeDates _relevantUnderlyingDate) {
            this.relevantUnderlyingDate = _relevantUnderlyingDate == null ? null : _relevantUnderlyingDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseTime")
        @RuneAttribute(value="earliestExerciseTime")
        public ExerciseTermsBuilder setEarliestExerciseTime(BusinessCenterTime _earliestExerciseTime) {
            this.earliestExerciseTime = _earliestExerciseTime == null ? null : _earliestExerciseTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTime")
        @RuneAttribute(value="latestExerciseTime")
        public ExerciseTermsBuilder setLatestExerciseTime(BusinessCenterTime _latestExerciseTime) {
            this.latestExerciseTime = _latestExerciseTime == null ? null : _latestExerciseTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationTime")
        @RuneAttribute(value="expirationTime")
        public ExerciseTermsBuilder setExpirationTime(BusinessCenterTime _expirationTime) {
            this.expirationTime = _expirationTime == null ? null : _expirationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationTimeType", isRequired=true)
        @RuneAttribute(value="expirationTimeType", isRequired=true)
        public ExerciseTermsBuilder setExpirationTimeType(ExpirationTimeTypeEnum _expirationTimeType) {
            this.expirationTimeType = _expirationTimeType == null ? null : _expirationTimeType;
            return this;
        }

        @Override
        @RosettaAttribute(value="multipleExercise")
        @RuneAttribute(value="multipleExercise")
        public ExerciseTermsBuilder setMultipleExercise(MultipleExercise _multipleExercise) {
            this.multipleExercise = _multipleExercise == null ? null : _multipleExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseFeeSchedule")
        @RuneAttribute(value="exerciseFeeSchedule")
        public ExerciseTermsBuilder setExerciseFeeSchedule(ExerciseFeeSchedule _exerciseFeeSchedule) {
            this.exerciseFeeSchedule = _exerciseFeeSchedule == null ? null : _exerciseFeeSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseTermsBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseFee")
        @RuneAttribute(value="exerciseFee")
        public ExerciseTermsBuilder setExerciseFee(ExerciseFee _exerciseFee) {
            this.exerciseFee = _exerciseFee == null ? null : _exerciseFee.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partialExercise")
        @RuneAttribute(value="partialExercise")
        public ExerciseTermsBuilder setPartialExercise(PartialExercise _partialExercise) {
            this.partialExercise = _partialExercise == null ? null : _partialExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public ExerciseTermsBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public ExerciseTerms build() {
            return new ExerciseTermsImpl(this);
        }

        @Override
        public ExerciseTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public ExerciseTermsBuilder prune() {
            if (this.commencementDate != null && !this.commencementDate.prune().hasData()) {
                this.commencementDate = null;
            }
            if (this.exerciseDates != null && !this.exerciseDates.prune().hasData()) {
                this.exerciseDates = null;
            }
            this.expirationDate = this.expirationDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.relevantUnderlyingDate != null && !this.relevantUnderlyingDate.prune().hasData()) {
                this.relevantUnderlyingDate = null;
            }
            if (this.earliestExerciseTime != null && !this.earliestExerciseTime.prune().hasData()) {
                this.earliestExerciseTime = null;
            }
            if (this.latestExerciseTime != null && !this.latestExerciseTime.prune().hasData()) {
                this.latestExerciseTime = null;
            }
            if (this.expirationTime != null && !this.expirationTime.prune().hasData()) {
                this.expirationTime = null;
            }
            if (this.multipleExercise != null && !this.multipleExercise.prune().hasData()) {
                this.multipleExercise = null;
            }
            if (this.exerciseFeeSchedule != null && !this.exerciseFeeSchedule.prune().hasData()) {
                this.exerciseFeeSchedule = null;
            }
            if (this.exerciseProcedure != null && !this.exerciseProcedure.prune().hasData()) {
                this.exerciseProcedure = null;
            }
            if (this.exerciseFee != null && !this.exerciseFee.prune().hasData()) {
                this.exerciseFee = null;
            }
            if (this.partialExercise != null && !this.partialExercise.prune().hasData()) {
                this.partialExercise = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStyle() != null) {
                return true;
            }
            if (this.getCommencementDate() != null && this.getCommencementDate().hasData()) {
                return true;
            }
            if (this.getExerciseDates() != null && this.getExerciseDates().hasData()) {
                return true;
            }
            if (this.getExpirationDate() != null && this.getExpirationDate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRelevantUnderlyingDate() != null && this.getRelevantUnderlyingDate().hasData()) {
                return true;
            }
            if (this.getEarliestExerciseTime() != null && this.getEarliestExerciseTime().hasData()) {
                return true;
            }
            if (this.getLatestExerciseTime() != null && this.getLatestExerciseTime().hasData()) {
                return true;
            }
            if (this.getExpirationTime() != null && this.getExpirationTime().hasData()) {
                return true;
            }
            if (this.getExpirationTimeType() != null) {
                return true;
            }
            if (this.getMultipleExercise() != null && this.getMultipleExercise().hasData()) {
                return true;
            }
            if (this.getExerciseFeeSchedule() != null && this.getExerciseFeeSchedule().hasData()) {
                return true;
            }
            if (this.getExerciseProcedure() != null && this.getExerciseProcedure().hasData()) {
                return true;
            }
            if (this.getExerciseFee() != null && this.getExerciseFee().hasData()) {
                return true;
            }
            return this.getPartialExercise() != null && this.getPartialExercise().hasData();
        }

        public ExerciseTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExerciseTermsBuilder o = (ExerciseTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommencementDate(), (RosettaModelObjectBuilder)o.getCommencementDate(), this::setCommencementDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseDates(), (RosettaModelObjectBuilder)o.getExerciseDates(), this::setExerciseDates);
            merger.mergeRosetta(this.getExpirationDate(), o.getExpirationDate(), this::getOrCreateExpirationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRelevantUnderlyingDate(), (RosettaModelObjectBuilder)o.getRelevantUnderlyingDate(), this::setRelevantUnderlyingDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarliestExerciseTime(), (RosettaModelObjectBuilder)o.getEarliestExerciseTime(), this::setEarliestExerciseTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLatestExerciseTime(), (RosettaModelObjectBuilder)o.getLatestExerciseTime(), this::setLatestExerciseTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirationTime(), (RosettaModelObjectBuilder)o.getExpirationTime(), this::setExpirationTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMultipleExercise(), (RosettaModelObjectBuilder)o.getMultipleExercise(), this::setMultipleExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseFeeSchedule(), (RosettaModelObjectBuilder)o.getExerciseFeeSchedule(), this::setExerciseFeeSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseProcedure(), (RosettaModelObjectBuilder)o.getExerciseProcedure(), this::setExerciseProcedure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseFee(), (RosettaModelObjectBuilder)o.getExerciseFee(), this::setExerciseFee);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartialExercise(), (RosettaModelObjectBuilder)o.getPartialExercise(), this::setPartialExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getStyle(), (Object)o.getStyle(), this::setStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpirationTimeType(), (Object)o.getExpirationTimeType(), this::setExpirationTimeType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExerciseTerms _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.style, (Object)_that.getStyle())) {
                return false;
            }
            if (!Objects.equals(this.commencementDate, _that.getCommencementDate())) {
                return false;
            }
            if (!Objects.equals(this.exerciseDates, _that.getExerciseDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.relevantUnderlyingDate, _that.getRelevantUnderlyingDate())) {
                return false;
            }
            if (!Objects.equals(this.earliestExerciseTime, _that.getEarliestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.latestExerciseTime, _that.getLatestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.expirationTime, _that.getExpirationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.expirationTimeType, (Object)_that.getExpirationTimeType())) {
                return false;
            }
            if (!Objects.equals(this.multipleExercise, _that.getMultipleExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFeeSchedule, _that.getExerciseFeeSchedule())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFee, _that.getExerciseFee())) {
                return false;
            }
            if (!Objects.equals(this.partialExercise, _that.getPartialExercise())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.style != null ? ((Object)((Object)this.style)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commencementDate != null ? this.commencementDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseDates != null ? this.exerciseDates.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate.hashCode() : 0);
            _result = 31 * _result + (this.earliestExerciseTime != null ? this.earliestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.latestExerciseTime != null ? this.latestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTimeType != null ? ((Object)((Object)this.expirationTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.multipleExercise != null ? this.multipleExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFeeSchedule != null ? this.exerciseFeeSchedule.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFee != null ? this.exerciseFee.hashCode() : 0);
            _result = 31 * _result + (this.partialExercise != null ? this.partialExercise.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExerciseTermsBuilder {style=" + (Object)((Object)this.style) + ", commencementDate=" + this.commencementDate + ", exerciseDates=" + this.exerciseDates + ", expirationDate=" + this.expirationDate + ", relevantUnderlyingDate=" + this.relevantUnderlyingDate + ", earliestExerciseTime=" + this.earliestExerciseTime + ", latestExerciseTime=" + this.latestExerciseTime + ", expirationTime=" + this.expirationTime + ", expirationTimeType=" + (Object)((Object)this.expirationTimeType) + ", multipleExercise=" + this.multipleExercise + ", exerciseFeeSchedule=" + this.exerciseFeeSchedule + ", exerciseProcedure=" + this.exerciseProcedure + ", exerciseFee=" + this.exerciseFee + ", partialExercise=" + this.partialExercise + ", meta=" + this.meta + '}';
        }
    }

    public static interface ExerciseTermsBuilder
    extends ExerciseTerms,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateCommencementDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getCommencementDate();

        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateExerciseDates();

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getExerciseDates();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate(int var1);

        public List<? extends AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> getExpirationDate();

        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateRelevantUnderlyingDate();

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getRelevantUnderlyingDate();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestExerciseTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestExerciseTime();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateLatestExerciseTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getLatestExerciseTime();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpirationTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpirationTime();

        public MultipleExercise.MultipleExerciseBuilder getOrCreateMultipleExercise();

        @Override
        public MultipleExercise.MultipleExerciseBuilder getMultipleExercise();

        public ExerciseFeeSchedule.ExerciseFeeScheduleBuilder getOrCreateExerciseFeeSchedule();

        @Override
        public ExerciseFeeSchedule.ExerciseFeeScheduleBuilder getExerciseFeeSchedule();

        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure();

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure();

        public ExerciseFee.ExerciseFeeBuilder getOrCreateExerciseFee();

        @Override
        public ExerciseFee.ExerciseFeeBuilder getExerciseFee();

        public PartialExercise.PartialExerciseBuilder getOrCreatePartialExercise();

        @Override
        public PartialExercise.PartialExerciseBuilder getPartialExercise();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public ExerciseTermsBuilder setStyle(OptionExerciseStyleEnum var1);

        public ExerciseTermsBuilder setCommencementDate(AdjustableOrRelativeDate var1);

        public ExerciseTermsBuilder setExerciseDates(AdjustableOrRelativeDates var1);

        public ExerciseTermsBuilder addExpirationDate(AdjustableOrRelativeDate var1);

        public ExerciseTermsBuilder addExpirationDate(AdjustableOrRelativeDate var1, int var2);

        public ExerciseTermsBuilder addExpirationDate(List<? extends AdjustableOrRelativeDate> var1);

        public ExerciseTermsBuilder setExpirationDate(List<? extends AdjustableOrRelativeDate> var1);

        public ExerciseTermsBuilder setRelevantUnderlyingDate(AdjustableOrRelativeDates var1);

        public ExerciseTermsBuilder setEarliestExerciseTime(BusinessCenterTime var1);

        public ExerciseTermsBuilder setLatestExerciseTime(BusinessCenterTime var1);

        public ExerciseTermsBuilder setExpirationTime(BusinessCenterTime var1);

        public ExerciseTermsBuilder setExpirationTimeType(ExpirationTimeTypeEnum var1);

        public ExerciseTermsBuilder setMultipleExercise(MultipleExercise var1);

        public ExerciseTermsBuilder setExerciseFeeSchedule(ExerciseFeeSchedule var1);

        public ExerciseTermsBuilder setExerciseProcedure(ExerciseProcedure var1);

        public ExerciseTermsBuilder setExerciseFee(ExerciseFee var1);

        public ExerciseTermsBuilder setPartialExercise(PartialExercise var1);

        public ExerciseTermsBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("style"), OptionExerciseStyleEnum.class, (Object)this.getStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commencementDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getCommencementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseDates"), processor, AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder.class, this.getExerciseDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relevantUnderlyingDate"), processor, AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder.class, this.getRelevantUnderlyingDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earliestExerciseTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getEarliestExerciseTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("latestExerciseTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getLatestExerciseTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getExpirationTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationTimeType"), ExpirationTimeTypeEnum.class, (Object)this.getExpirationTimeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("multipleExercise"), processor, MultipleExercise.MultipleExerciseBuilder.class, this.getMultipleExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseFeeSchedule"), processor, ExerciseFeeSchedule.ExerciseFeeScheduleBuilder.class, this.getExerciseFeeSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseFee"), processor, ExerciseFee.ExerciseFeeBuilder.class, this.getExerciseFee(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partialExercise"), processor, PartialExercise.PartialExerciseBuilder.class, this.getPartialExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public ExerciseTermsBuilder prune();
    }

    public static class ExerciseTermsImpl
    implements ExerciseTerms {
        private final OptionExerciseStyleEnum style;
        private final AdjustableOrRelativeDate commencementDate;
        private final AdjustableOrRelativeDates exerciseDates;
        private final List<? extends AdjustableOrRelativeDate> expirationDate;
        private final AdjustableOrRelativeDates relevantUnderlyingDate;
        private final BusinessCenterTime earliestExerciseTime;
        private final BusinessCenterTime latestExerciseTime;
        private final BusinessCenterTime expirationTime;
        private final ExpirationTimeTypeEnum expirationTimeType;
        private final MultipleExercise multipleExercise;
        private final ExerciseFeeSchedule exerciseFeeSchedule;
        private final ExerciseProcedure exerciseProcedure;
        private final ExerciseFee exerciseFee;
        private final PartialExercise partialExercise;
        private final MetaFields meta;

        protected ExerciseTermsImpl(ExerciseTermsBuilder builder) {
            this.style = builder.getStyle();
            this.commencementDate = Optional.ofNullable(builder.getCommencementDate()).map(f -> f.build()).orElse(null);
            this.exerciseDates = Optional.ofNullable(builder.getExerciseDates()).map(f -> f.build()).orElse(null);
            this.expirationDate = Optional.ofNullable(builder.getExpirationDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.relevantUnderlyingDate = Optional.ofNullable(builder.getRelevantUnderlyingDate()).map(f -> f.build()).orElse(null);
            this.earliestExerciseTime = Optional.ofNullable(builder.getEarliestExerciseTime()).map(f -> f.build()).orElse(null);
            this.latestExerciseTime = Optional.ofNullable(builder.getLatestExerciseTime()).map(f -> f.build()).orElse(null);
            this.expirationTime = Optional.ofNullable(builder.getExpirationTime()).map(f -> f.build()).orElse(null);
            this.expirationTimeType = builder.getExpirationTimeType();
            this.multipleExercise = Optional.ofNullable(builder.getMultipleExercise()).map(f -> f.build()).orElse(null);
            this.exerciseFeeSchedule = Optional.ofNullable(builder.getExerciseFeeSchedule()).map(f -> f.build()).orElse(null);
            this.exerciseProcedure = Optional.ofNullable(builder.getExerciseProcedure()).map(f -> f.build()).orElse(null);
            this.exerciseFee = Optional.ofNullable(builder.getExerciseFee()).map(f -> f.build()).orElse(null);
            this.partialExercise = Optional.ofNullable(builder.getPartialExercise()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="style")
        @RuneAttribute(value="style")
        public OptionExerciseStyleEnum getStyle() {
            return this.style;
        }

        @Override
        @RosettaAttribute(value="commencementDate")
        @RuneAttribute(value="commencementDate")
        public AdjustableOrRelativeDate getCommencementDate() {
            return this.commencementDate;
        }

        @Override
        @RosettaAttribute(value="exerciseDates")
        @RuneAttribute(value="exerciseDates")
        public AdjustableOrRelativeDates getExerciseDates() {
            return this.exerciseDates;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public List<? extends AdjustableOrRelativeDate> getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="relevantUnderlyingDate")
        @RuneAttribute(value="relevantUnderlyingDate")
        public AdjustableOrRelativeDates getRelevantUnderlyingDate() {
            return this.relevantUnderlyingDate;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseTime")
        @RuneAttribute(value="earliestExerciseTime")
        public BusinessCenterTime getEarliestExerciseTime() {
            return this.earliestExerciseTime;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTime")
        @RuneAttribute(value="latestExerciseTime")
        public BusinessCenterTime getLatestExerciseTime() {
            return this.latestExerciseTime;
        }

        @Override
        @RosettaAttribute(value="expirationTime")
        @RuneAttribute(value="expirationTime")
        public BusinessCenterTime getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        @RosettaAttribute(value="expirationTimeType", isRequired=true)
        @RuneAttribute(value="expirationTimeType", isRequired=true)
        public ExpirationTimeTypeEnum getExpirationTimeType() {
            return this.expirationTimeType;
        }

        @Override
        @RosettaAttribute(value="multipleExercise")
        @RuneAttribute(value="multipleExercise")
        public MultipleExercise getMultipleExercise() {
            return this.multipleExercise;
        }

        @Override
        @RosettaAttribute(value="exerciseFeeSchedule")
        @RuneAttribute(value="exerciseFeeSchedule")
        public ExerciseFeeSchedule getExerciseFeeSchedule() {
            return this.exerciseFeeSchedule;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        @RosettaAttribute(value="exerciseFee")
        @RuneAttribute(value="exerciseFee")
        public ExerciseFee getExerciseFee() {
            return this.exerciseFee;
        }

        @Override
        @RosettaAttribute(value="partialExercise")
        @RuneAttribute(value="partialExercise")
        public PartialExercise getPartialExercise() {
            return this.partialExercise;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public ExerciseTerms build() {
            return this;
        }

        @Override
        public ExerciseTermsBuilder toBuilder() {
            ExerciseTermsBuilder builder = ExerciseTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExerciseTermsBuilder builder) {
            Optional.ofNullable(this.getStyle()).ifPresent(builder::setStyle);
            Optional.ofNullable(this.getCommencementDate()).ifPresent(builder::setCommencementDate);
            Optional.ofNullable(this.getExerciseDates()).ifPresent(builder::setExerciseDates);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getRelevantUnderlyingDate()).ifPresent(builder::setRelevantUnderlyingDate);
            Optional.ofNullable(this.getEarliestExerciseTime()).ifPresent(builder::setEarliestExerciseTime);
            Optional.ofNullable(this.getLatestExerciseTime()).ifPresent(builder::setLatestExerciseTime);
            Optional.ofNullable(this.getExpirationTime()).ifPresent(builder::setExpirationTime);
            Optional.ofNullable(this.getExpirationTimeType()).ifPresent(builder::setExpirationTimeType);
            Optional.ofNullable(this.getMultipleExercise()).ifPresent(builder::setMultipleExercise);
            Optional.ofNullable(this.getExerciseFeeSchedule()).ifPresent(builder::setExerciseFeeSchedule);
            Optional.ofNullable(this.getExerciseProcedure()).ifPresent(builder::setExerciseProcedure);
            Optional.ofNullable(this.getExerciseFee()).ifPresent(builder::setExerciseFee);
            Optional.ofNullable(this.getPartialExercise()).ifPresent(builder::setPartialExercise);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExerciseTerms _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.style, (Object)_that.getStyle())) {
                return false;
            }
            if (!Objects.equals(this.commencementDate, _that.getCommencementDate())) {
                return false;
            }
            if (!Objects.equals(this.exerciseDates, _that.getExerciseDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.relevantUnderlyingDate, _that.getRelevantUnderlyingDate())) {
                return false;
            }
            if (!Objects.equals(this.earliestExerciseTime, _that.getEarliestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.latestExerciseTime, _that.getLatestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.expirationTime, _that.getExpirationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.expirationTimeType, (Object)_that.getExpirationTimeType())) {
                return false;
            }
            if (!Objects.equals(this.multipleExercise, _that.getMultipleExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFeeSchedule, _that.getExerciseFeeSchedule())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFee, _that.getExerciseFee())) {
                return false;
            }
            if (!Objects.equals(this.partialExercise, _that.getPartialExercise())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.style != null ? ((Object)((Object)this.style)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commencementDate != null ? this.commencementDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseDates != null ? this.exerciseDates.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate.hashCode() : 0);
            _result = 31 * _result + (this.earliestExerciseTime != null ? this.earliestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.latestExerciseTime != null ? this.latestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTimeType != null ? ((Object)((Object)this.expirationTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.multipleExercise != null ? this.multipleExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFeeSchedule != null ? this.exerciseFeeSchedule.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFee != null ? this.exerciseFee.hashCode() : 0);
            _result = 31 * _result + (this.partialExercise != null ? this.partialExercise.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExerciseTerms {style=" + (Object)((Object)this.style) + ", commencementDate=" + this.commencementDate + ", exerciseDates=" + this.exerciseDates + ", expirationDate=" + this.expirationDate + ", relevantUnderlyingDate=" + this.relevantUnderlyingDate + ", earliestExerciseTime=" + this.earliestExerciseTime + ", latestExerciseTime=" + this.latestExerciseTime + ", expirationTime=" + this.expirationTime + ", expirationTimeType=" + (Object)((Object)this.expirationTimeType) + ", multipleExercise=" + this.multipleExercise + ", exerciseFeeSchedule=" + this.exerciseFeeSchedule + ", exerciseProcedure=" + this.exerciseProcedure + ", exerciseFee=" + this.exerciseFee + ", partialExercise=" + this.partialExercise + ", meta=" + this.meta + '}';
        }
    }
}

