/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.processor;

import cdm.product.common.settlement.ResolvablePriceQuantity;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.stream.Collectors;

public class CdsFeeLegMetaMappingProcessor
extends MappingProcessor {
    public CdsFeeLegMetaMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path protectionTermsCalculationAmountSynonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        if (!protectionTermsCalculationAmountSynonymPath.endsWith(new String[]{"protectionTerms", "calculationAmount", "amount"})) {
            return;
        }
        Path modelPath = PathUtils.toPath((RosettaPath)this.getModelPath().getParent());
        List<Mapping> legPriceQuantityMappings = this.filterMappingForModelPath(modelPath);
        if (CdsFeeLegMetaMappingProcessor.isDuplicateInterestRatePayout(modelPath).booleanValue()) {
            ((ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)parent).setQuantitySchedule(null);
            this.getMappings().removeAll(legPriceQuantityMappings);
            return;
        }
        List<Mapping> legReferenceMappings = legPriceQuantityMappings.stream().filter(m -> m.getRosettaValue() instanceof Reference.ReferenceBuilder).collect(Collectors.toList());
        if (this.containsPathElement(legReferenceMappings, "feeLeg") && this.containsPathElement(legReferenceMappings, "protectionTerms")) {
            Path notionalPath = protectionTermsCalculationAmountSynonymPath;
            List notionalMappings = legPriceQuantityMappings.stream().filter(m -> m.getXmlPath().nameIndexMatches(notionalPath)).collect(Collectors.toList());
            this.getMappings().removeAll(notionalMappings);
            legPriceQuantityMappings.removeAll(notionalMappings);
            Path idPath = protectionTermsCalculationAmountSynonymPath.getParent().addElement("id");
            List idMappings = legPriceQuantityMappings.stream().filter(m -> m.getXmlPath().nameIndexMatches(idPath)).collect(Collectors.toList());
            if (this.getMappings().removeAll(idMappings)) {
                ((ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)parent).getOrCreateMeta().setExternalKey(null);
            }
            legPriceQuantityMappings.removeAll(idMappings);
            legPriceQuantityMappings.forEach(this::updateMappingSuccess);
        }
    }

    private static Boolean isDuplicateInterestRatePayout(Path modelPath) {
        return MappingProcessorUtils.subPath((String)"payout", (Path)modelPath).map(Path::getLastElement).map(e -> e.forceGetIndex() > 1).orElse(false);
    }

    private List<Mapping> filterMappingForModelPath(Path modelPath) {
        return this.getMappings().stream().filter(m -> m.getRosettaPath() != null).filter(m -> modelPath.fullStartMatches(m.getRosettaPath())).collect(Collectors.toList());
    }

    private boolean containsPathElement(List<Mapping> referenceMappings, String pathElement) {
        return referenceMappings.stream().anyMatch(m -> m.getXmlPath().toString().contains(pathElement));
    }

    private void updateMappingSuccess(Mapping mapping) {
        mapping.setError(null);
        mapping.setCondition(true);
        mapping.setDuplicate(false);
    }
}

