/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.product.collateral.CollateralCriteria;
import cdm.product.collateral.CollateralMarginTypeEnum;
import cdm.product.collateral.RatingPriorityResolutionEnum;
import cdm.product.collateral.meta.CollateralCriteriaBaseMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CollateralCriteriaBase", builder=CollateralCriteriaBaseBuilderImpl.class, version="6.10.0")
@RuneDataType(value="CollateralCriteriaBase", model="cdm", builder=CollateralCriteriaBaseBuilderImpl.class, version="6.10.0")
public interface CollateralCriteriaBase
extends RosettaModelObject {
    public static final CollateralCriteriaBaseMeta metaData = new CollateralCriteriaBaseMeta();

    public CollateralCriteria getCollateralCriteria();

    public List<CounterpartyRoleEnum> getAppliesTo();

    public CollateralMarginTypeEnum getRestrictTo();

    public RatingPriorityResolutionEnum getRatingPriorityResolution();

    public CollateralCriteriaBase build();

    public CollateralCriteriaBaseBuilder toBuilder();

    public static CollateralCriteriaBaseBuilder builder() {
        return new CollateralCriteriaBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralCriteriaBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralCriteriaBase> getType() {
        return CollateralCriteriaBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("collateralCriteria"), processor, CollateralCriteria.class, this.getCollateralCriteria(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("appliesTo"), CounterpartyRoleEnum.class, this.getAppliesTo(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("restrictTo"), CollateralMarginTypeEnum.class, (Object)this.getRestrictTo(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ratingPriorityResolution"), RatingPriorityResolutionEnum.class, (Object)this.getRatingPriorityResolution(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CollateralCriteriaBaseBuilderImpl
    implements CollateralCriteriaBaseBuilder {
        protected CollateralCriteria.CollateralCriteriaBuilder collateralCriteria;
        protected List<CounterpartyRoleEnum> appliesTo = new ArrayList<CounterpartyRoleEnum>();
        protected CollateralMarginTypeEnum restrictTo;
        protected RatingPriorityResolutionEnum ratingPriorityResolution;

        @Override
        @RosettaAttribute(value="collateralCriteria")
        @RuneAttribute(value="collateralCriteria")
        public CollateralCriteria.CollateralCriteriaBuilder getCollateralCriteria() {
            return this.collateralCriteria;
        }

        @Override
        public CollateralCriteria.CollateralCriteriaBuilder getOrCreateCollateralCriteria() {
            CollateralCriteria.CollateralCriteriaBuilder result = this.collateralCriteria != null ? this.collateralCriteria : (this.collateralCriteria = CollateralCriteria.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="appliesTo")
        @RuneAttribute(value="appliesTo")
        public List<CounterpartyRoleEnum> getAppliesTo() {
            return this.appliesTo;
        }

        @Override
        @RosettaAttribute(value="restrictTo")
        @RuneAttribute(value="restrictTo")
        public CollateralMarginTypeEnum getRestrictTo() {
            return this.restrictTo;
        }

        @Override
        @RosettaAttribute(value="ratingPriorityResolution")
        @RuneAttribute(value="ratingPriorityResolution")
        public RatingPriorityResolutionEnum getRatingPriorityResolution() {
            return this.ratingPriorityResolution;
        }

        @Override
        @RosettaAttribute(value="collateralCriteria")
        @RuneAttribute(value="collateralCriteria")
        public CollateralCriteriaBaseBuilder setCollateralCriteria(CollateralCriteria _collateralCriteria) {
            this.collateralCriteria = _collateralCriteria == null ? null : _collateralCriteria.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="appliesTo")
        @RuneAttribute(value="appliesTo")
        public CollateralCriteriaBaseBuilder addAppliesTo(CounterpartyRoleEnum _appliesTo) {
            if (_appliesTo != null) {
                this.appliesTo.add(_appliesTo);
            }
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder addAppliesTo(CounterpartyRoleEnum _appliesTo, int idx) {
            this.getIndex(this.appliesTo, idx, () -> _appliesTo);
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder addAppliesTo(List<CounterpartyRoleEnum> appliesTos) {
            if (appliesTos != null) {
                for (CounterpartyRoleEnum toAdd : appliesTos) {
                    this.appliesTo.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="appliesTo")
        public CollateralCriteriaBaseBuilder setAppliesTo(List<CounterpartyRoleEnum> appliesTos) {
            this.appliesTo = appliesTos == null ? new ArrayList<CounterpartyRoleEnum>() : (List)appliesTos.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="restrictTo")
        @RuneAttribute(value="restrictTo")
        public CollateralCriteriaBaseBuilder setRestrictTo(CollateralMarginTypeEnum _restrictTo) {
            this.restrictTo = _restrictTo == null ? null : _restrictTo;
            return this;
        }

        @Override
        @RosettaAttribute(value="ratingPriorityResolution")
        @RuneAttribute(value="ratingPriorityResolution")
        public CollateralCriteriaBaseBuilder setRatingPriorityResolution(RatingPriorityResolutionEnum _ratingPriorityResolution) {
            this.ratingPriorityResolution = _ratingPriorityResolution == null ? null : _ratingPriorityResolution;
            return this;
        }

        @Override
        public CollateralCriteriaBase build() {
            return new CollateralCriteriaBaseImpl(this);
        }

        @Override
        public CollateralCriteriaBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder prune() {
            if (this.collateralCriteria != null && !this.collateralCriteria.prune().hasData()) {
                this.collateralCriteria = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCollateralCriteria() != null && this.getCollateralCriteria().hasData()) {
                return true;
            }
            if (this.getAppliesTo() != null && !this.getAppliesTo().isEmpty()) {
                return true;
            }
            if (this.getRestrictTo() != null) {
                return true;
            }
            return this.getRatingPriorityResolution() != null;
        }

        public CollateralCriteriaBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralCriteriaBaseBuilder o = (CollateralCriteriaBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralCriteria(), (RosettaModelObjectBuilder)o.getCollateralCriteria(), this::setCollateralCriteria);
            merger.mergeBasic(this.getAppliesTo(), o.getAppliesTo(), this::addAppliesTo);
            merger.mergeBasic((Object)this.getRestrictTo(), (Object)o.getRestrictTo(), this::setRestrictTo, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRatingPriorityResolution(), (Object)o.getRatingPriorityResolution(), this::setRatingPriorityResolution, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralCriteriaBase _that = this.getType().cast(o);
            if (!Objects.equals(this.collateralCriteria, _that.getCollateralCriteria())) {
                return false;
            }
            if (!ListEquals.listEquals(this.appliesTo, _that.getAppliesTo())) {
                return false;
            }
            if (!Objects.equals((Object)this.restrictTo, (Object)_that.getRestrictTo())) {
                return false;
            }
            return Objects.equals((Object)this.ratingPriorityResolution, (Object)_that.getRatingPriorityResolution());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralCriteria != null ? this.collateralCriteria.hashCode() : 0);
            _result = 31 * _result + (this.appliesTo != null ? this.appliesTo.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.restrictTo != null ? ((Object)((Object)this.restrictTo)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ratingPriorityResolution != null ? ((Object)((Object)this.ratingPriorityResolution)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralCriteriaBaseBuilder {collateralCriteria=" + this.collateralCriteria + ", appliesTo=" + this.appliesTo + ", restrictTo=" + (Object)((Object)this.restrictTo) + ", ratingPriorityResolution=" + (Object)((Object)this.ratingPriorityResolution) + '}';
        }
    }

    public static interface CollateralCriteriaBaseBuilder
    extends CollateralCriteriaBase,
    RosettaModelObjectBuilder {
        public CollateralCriteria.CollateralCriteriaBuilder getOrCreateCollateralCriteria();

        @Override
        public CollateralCriteria.CollateralCriteriaBuilder getCollateralCriteria();

        public CollateralCriteriaBaseBuilder setCollateralCriteria(CollateralCriteria var1);

        public CollateralCriteriaBaseBuilder addAppliesTo(CounterpartyRoleEnum var1);

        public CollateralCriteriaBaseBuilder addAppliesTo(CounterpartyRoleEnum var1, int var2);

        public CollateralCriteriaBaseBuilder addAppliesTo(List<CounterpartyRoleEnum> var1);

        public CollateralCriteriaBaseBuilder setAppliesTo(List<CounterpartyRoleEnum> var1);

        public CollateralCriteriaBaseBuilder setRestrictTo(CollateralMarginTypeEnum var1);

        public CollateralCriteriaBaseBuilder setRatingPriorityResolution(RatingPriorityResolutionEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("collateralCriteria"), processor, CollateralCriteria.CollateralCriteriaBuilder.class, this.getCollateralCriteria(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("appliesTo"), CounterpartyRoleEnum.class, this.getAppliesTo(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("restrictTo"), CollateralMarginTypeEnum.class, (Object)this.getRestrictTo(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ratingPriorityResolution"), RatingPriorityResolutionEnum.class, (Object)this.getRatingPriorityResolution(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CollateralCriteriaBaseBuilder prune();
    }

    public static class CollateralCriteriaBaseImpl
    implements CollateralCriteriaBase {
        private final CollateralCriteria collateralCriteria;
        private final List<CounterpartyRoleEnum> appliesTo;
        private final CollateralMarginTypeEnum restrictTo;
        private final RatingPriorityResolutionEnum ratingPriorityResolution;

        protected CollateralCriteriaBaseImpl(CollateralCriteriaBaseBuilder builder) {
            this.collateralCriteria = Optional.ofNullable(builder.getCollateralCriteria()).map(f -> f.build()).orElse(null);
            this.appliesTo = Optional.ofNullable(builder.getAppliesTo()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.restrictTo = builder.getRestrictTo();
            this.ratingPriorityResolution = builder.getRatingPriorityResolution();
        }

        @Override
        @RosettaAttribute(value="collateralCriteria")
        @RuneAttribute(value="collateralCriteria")
        public CollateralCriteria getCollateralCriteria() {
            return this.collateralCriteria;
        }

        @Override
        @RosettaAttribute(value="appliesTo")
        @RuneAttribute(value="appliesTo")
        public List<CounterpartyRoleEnum> getAppliesTo() {
            return this.appliesTo;
        }

        @Override
        @RosettaAttribute(value="restrictTo")
        @RuneAttribute(value="restrictTo")
        public CollateralMarginTypeEnum getRestrictTo() {
            return this.restrictTo;
        }

        @Override
        @RosettaAttribute(value="ratingPriorityResolution")
        @RuneAttribute(value="ratingPriorityResolution")
        public RatingPriorityResolutionEnum getRatingPriorityResolution() {
            return this.ratingPriorityResolution;
        }

        @Override
        public CollateralCriteriaBase build() {
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder toBuilder() {
            CollateralCriteriaBaseBuilder builder = CollateralCriteriaBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralCriteriaBaseBuilder builder) {
            Optional.ofNullable(this.getCollateralCriteria()).ifPresent(builder::setCollateralCriteria);
            Optional.ofNullable(this.getAppliesTo()).ifPresent(builder::setAppliesTo);
            Optional.ofNullable(this.getRestrictTo()).ifPresent(builder::setRestrictTo);
            Optional.ofNullable(this.getRatingPriorityResolution()).ifPresent(builder::setRatingPriorityResolution);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralCriteriaBase _that = this.getType().cast(o);
            if (!Objects.equals(this.collateralCriteria, _that.getCollateralCriteria())) {
                return false;
            }
            if (!ListEquals.listEquals(this.appliesTo, _that.getAppliesTo())) {
                return false;
            }
            if (!Objects.equals((Object)this.restrictTo, (Object)_that.getRestrictTo())) {
                return false;
            }
            return Objects.equals((Object)this.ratingPriorityResolution, (Object)_that.getRatingPriorityResolution());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralCriteria != null ? this.collateralCriteria.hashCode() : 0);
            _result = 31 * _result + (this.appliesTo != null ? this.appliesTo.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.restrictTo != null ? ((Object)((Object)this.restrictTo)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ratingPriorityResolution != null ? ((Object)((Object)this.ratingPriorityResolution)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralCriteriaBase {collateralCriteria=" + this.collateralCriteria + ", appliesTo=" + this.appliesTo + ", restrictTo=" + (Object)((Object)this.restrictTo) + ", ratingPriorityResolution=" + (Object)((Object)this.ratingPriorityResolution) + '}';
        }
    }
}

