/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.IndexBase;
import cdm.observable.asset.InformationSource;
import cdm.observable.asset.QuotedCurrencyPair;
import cdm.observable.asset.meta.ForeignExchangeRateIndexMeta;
import cdm.observable.asset.metafields.FieldWithMetaQuotedCurrencyPair;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeKey;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ForeignExchangeRateIndex", builder=ForeignExchangeRateIndexBuilderImpl.class, version="6.10.0")
@RuneDataType(value="ForeignExchangeRateIndex", model="cdm", builder=ForeignExchangeRateIndexBuilderImpl.class, version="6.10.0")
public interface ForeignExchangeRateIndex
extends IndexBase {
    public static final ForeignExchangeRateIndexMeta metaData = new ForeignExchangeRateIndexMeta();

    public FieldWithMetaQuotedCurrencyPair getQuotedCurrencyPair();

    public InformationSource getPrimaryFxSpotRateSource();

    public InformationSource getSecondaryFxSpotRateSource();

    @Override
    public ForeignExchangeRateIndex build();

    @Override
    public ForeignExchangeRateIndexBuilder toBuilder();

    public static ForeignExchangeRateIndexBuilder builder() {
        return new ForeignExchangeRateIndexBuilderImpl();
    }

    default public RosettaMetaData<? extends ForeignExchangeRateIndex> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ForeignExchangeRateIndex> getType() {
        return ForeignExchangeRateIndex.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.class, this.getName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.class, this.getProvider(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, FieldWithMetaQuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("primaryFxSpotRateSource"), processor, InformationSource.class, this.getPrimaryFxSpotRateSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("secondaryFxSpotRateSource"), processor, InformationSource.class, this.getSecondaryFxSpotRateSource(), new AttributeMeta[0]);
    }

    public static class ForeignExchangeRateIndexBuilderImpl
    extends IndexBase.IndexBaseBuilderImpl
    implements ForeignExchangeRateIndexBuilder {
        protected FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder quotedCurrencyPair;
        protected InformationSource.InformationSourceBuilder primaryFxSpotRateSource;
        protected InformationSource.InformationSourceBuilder secondaryFxSpotRateSource;

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneScopedAttributeKey
        public FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder result;
            if (this.quotedCurrencyPair != null) {
                result = this.quotedCurrencyPair;
            } else {
                result = this.quotedCurrencyPair = FieldWithMetaQuotedCurrencyPair.builder();
                result.getOrCreateMeta().toBuilder().addKey((Key)Key.builder().setScope("DOCUMENT"));
            }
            return result;
        }

        @Override
        @RosettaAttribute(value="primaryFxSpotRateSource", isRequired=true)
        @RuneAttribute(value="primaryFxSpotRateSource", isRequired=true)
        public InformationSource.InformationSourceBuilder getPrimaryFxSpotRateSource() {
            return this.primaryFxSpotRateSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreatePrimaryFxSpotRateSource() {
            InformationSource.InformationSourceBuilder result = this.primaryFxSpotRateSource != null ? this.primaryFxSpotRateSource : (this.primaryFxSpotRateSource = InformationSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="secondaryFxSpotRateSource")
        @RuneAttribute(value="secondaryFxSpotRateSource")
        public InformationSource.InformationSourceBuilder getSecondaryFxSpotRateSource() {
            return this.secondaryFxSpotRateSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateSecondaryFxSpotRateSource() {
            InformationSource.InformationSourceBuilder result = this.secondaryFxSpotRateSource != null ? this.secondaryFxSpotRateSource : (this.secondaryFxSpotRateSource = InformationSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public ForeignExchangeRateIndexBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public ForeignExchangeRateIndexBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public ForeignExchangeRateIndexBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public ForeignExchangeRateIndexBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public ForeignExchangeRateIndexBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public ForeignExchangeRateIndexBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public ForeignExchangeRateIndexBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public ForeignExchangeRateIndexBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public ForeignExchangeRateIndexBuilder setName(FieldWithMetaString _name) {
            this.name = _name == null ? null : _name.toBuilder();
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder setNameValue(String _name) {
            this.getOrCreateName().setValue(_name);
            return this;
        }

        @Override
        @RosettaAttribute(value="provider")
        @RuneAttribute(value="provider")
        public ForeignExchangeRateIndexBuilder setProvider(LegalEntity _provider) {
            this.provider = _provider == null ? null : _provider.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public ForeignExchangeRateIndexBuilder setAssetClass(AssetClassEnum _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneScopedAttributeKey
        public ForeignExchangeRateIndexBuilder setQuotedCurrencyPair(FieldWithMetaQuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder setQuotedCurrencyPairValue(QuotedCurrencyPair _quotedCurrencyPair) {
            this.getOrCreateQuotedCurrencyPair().setValue(_quotedCurrencyPair);
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryFxSpotRateSource", isRequired=true)
        @RuneAttribute(value="primaryFxSpotRateSource", isRequired=true)
        public ForeignExchangeRateIndexBuilder setPrimaryFxSpotRateSource(InformationSource _primaryFxSpotRateSource) {
            this.primaryFxSpotRateSource = _primaryFxSpotRateSource == null ? null : _primaryFxSpotRateSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryFxSpotRateSource")
        @RuneAttribute(value="secondaryFxSpotRateSource")
        public ForeignExchangeRateIndexBuilder setSecondaryFxSpotRateSource(InformationSource _secondaryFxSpotRateSource) {
            this.secondaryFxSpotRateSource = _secondaryFxSpotRateSource == null ? null : _secondaryFxSpotRateSource.toBuilder();
            return this;
        }

        @Override
        public ForeignExchangeRateIndex build() {
            return new ForeignExchangeRateIndexImpl(this);
        }

        @Override
        public ForeignExchangeRateIndexBuilder toBuilder() {
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder prune() {
            super.prune();
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            if (this.primaryFxSpotRateSource != null && !this.primaryFxSpotRateSource.prune().hasData()) {
                this.primaryFxSpotRateSource = null;
            }
            if (this.secondaryFxSpotRateSource != null && !this.secondaryFxSpotRateSource.prune().hasData()) {
                this.secondaryFxSpotRateSource = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getPrimaryFxSpotRateSource() != null && this.getPrimaryFxSpotRateSource().hasData()) {
                return true;
            }
            return this.getSecondaryFxSpotRateSource() != null && this.getSecondaryFxSpotRateSource().hasData();
        }

        @Override
        public ForeignExchangeRateIndexBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ForeignExchangeRateIndexBuilder o = (ForeignExchangeRateIndexBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryFxSpotRateSource(), (RosettaModelObjectBuilder)o.getPrimaryFxSpotRateSource(), this::setPrimaryFxSpotRateSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecondaryFxSpotRateSource(), (RosettaModelObjectBuilder)o.getSecondaryFxSpotRateSource(), this::setSecondaryFxSpotRateSource);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ForeignExchangeRateIndex _that = (ForeignExchangeRateIndex)this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.primaryFxSpotRateSource, _that.getPrimaryFxSpotRateSource())) {
                return false;
            }
            return Objects.equals(this.secondaryFxSpotRateSource, _that.getSecondaryFxSpotRateSource());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.primaryFxSpotRateSource != null ? this.primaryFxSpotRateSource.hashCode() : 0);
            _result = 31 * _result + (this.secondaryFxSpotRateSource != null ? this.secondaryFxSpotRateSource.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ForeignExchangeRateIndexBuilder {quotedCurrencyPair=" + this.quotedCurrencyPair + ", primaryFxSpotRateSource=" + this.primaryFxSpotRateSource + ", secondaryFxSpotRateSource=" + this.secondaryFxSpotRateSource + '}' + " " + super.toString();
        }
    }

    public static interface ForeignExchangeRateIndexBuilder
    extends ForeignExchangeRateIndex,
    IndexBase.IndexBaseBuilder {
        public FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public InformationSource.InformationSourceBuilder getOrCreatePrimaryFxSpotRateSource();

        @Override
        public InformationSource.InformationSourceBuilder getPrimaryFxSpotRateSource();

        public InformationSource.InformationSourceBuilder getOrCreateSecondaryFxSpotRateSource();

        @Override
        public InformationSource.InformationSourceBuilder getSecondaryFxSpotRateSource();

        @Override
        public ForeignExchangeRateIndexBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public ForeignExchangeRateIndexBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public ForeignExchangeRateIndexBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public ForeignExchangeRateIndexBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public ForeignExchangeRateIndexBuilder addTaxonomy(Taxonomy var1);

        @Override
        public ForeignExchangeRateIndexBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public ForeignExchangeRateIndexBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public ForeignExchangeRateIndexBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public ForeignExchangeRateIndexBuilder setIsExchangeListed(Boolean var1);

        @Override
        public ForeignExchangeRateIndexBuilder setExchange(LegalEntity var1);

        @Override
        public ForeignExchangeRateIndexBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public ForeignExchangeRateIndexBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public ForeignExchangeRateIndexBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public ForeignExchangeRateIndexBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public ForeignExchangeRateIndexBuilder setName(FieldWithMetaString var1);

        @Override
        public ForeignExchangeRateIndexBuilder setNameValue(String var1);

        @Override
        public ForeignExchangeRateIndexBuilder setProvider(LegalEntity var1);

        @Override
        public ForeignExchangeRateIndexBuilder setAssetClass(AssetClassEnum var1);

        public ForeignExchangeRateIndexBuilder setQuotedCurrencyPair(FieldWithMetaQuotedCurrencyPair var1);

        public ForeignExchangeRateIndexBuilder setQuotedCurrencyPairValue(QuotedCurrencyPair var1);

        public ForeignExchangeRateIndexBuilder setPrimaryFxSpotRateSource(InformationSource var1);

        public ForeignExchangeRateIndexBuilder setSecondaryFxSpotRateSource(InformationSource var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, (RosettaModelObjectBuilder)this.getName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getProvider(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("primaryFxSpotRateSource"), processor, InformationSource.InformationSourceBuilder.class, this.getPrimaryFxSpotRateSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("secondaryFxSpotRateSource"), processor, InformationSource.InformationSourceBuilder.class, this.getSecondaryFxSpotRateSource(), new AttributeMeta[0]);
        }

        @Override
        public ForeignExchangeRateIndexBuilder prune();
    }

    public static class ForeignExchangeRateIndexImpl
    extends IndexBase.IndexBaseImpl
    implements ForeignExchangeRateIndex {
        private final FieldWithMetaQuotedCurrencyPair quotedCurrencyPair;
        private final InformationSource primaryFxSpotRateSource;
        private final InformationSource secondaryFxSpotRateSource;

        protected ForeignExchangeRateIndexImpl(ForeignExchangeRateIndexBuilder builder) {
            super(builder);
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.primaryFxSpotRateSource = Optional.ofNullable(builder.getPrimaryFxSpotRateSource()).map(f -> f.build()).orElse(null);
            this.secondaryFxSpotRateSource = Optional.ofNullable(builder.getSecondaryFxSpotRateSource()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneScopedAttributeKey
        public FieldWithMetaQuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="primaryFxSpotRateSource", isRequired=true)
        @RuneAttribute(value="primaryFxSpotRateSource", isRequired=true)
        public InformationSource getPrimaryFxSpotRateSource() {
            return this.primaryFxSpotRateSource;
        }

        @Override
        @RosettaAttribute(value="secondaryFxSpotRateSource")
        @RuneAttribute(value="secondaryFxSpotRateSource")
        public InformationSource getSecondaryFxSpotRateSource() {
            return this.secondaryFxSpotRateSource;
        }

        @Override
        public ForeignExchangeRateIndex build() {
            return this;
        }

        @Override
        public ForeignExchangeRateIndexBuilder toBuilder() {
            ForeignExchangeRateIndexBuilder builder = ForeignExchangeRateIndex.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ForeignExchangeRateIndexBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getPrimaryFxSpotRateSource()).ifPresent(builder::setPrimaryFxSpotRateSource);
            Optional.ofNullable(this.getSecondaryFxSpotRateSource()).ifPresent(builder::setSecondaryFxSpotRateSource);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ForeignExchangeRateIndex _that = (ForeignExchangeRateIndex)this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.primaryFxSpotRateSource, _that.getPrimaryFxSpotRateSource())) {
                return false;
            }
            return Objects.equals(this.secondaryFxSpotRateSource, _that.getSecondaryFxSpotRateSource());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.primaryFxSpotRateSource != null ? this.primaryFxSpotRateSource.hashCode() : 0);
            _result = 31 * _result + (this.secondaryFxSpotRateSource != null ? this.secondaryFxSpotRateSource.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ForeignExchangeRateIndex {quotedCurrencyPair=" + this.quotedCurrencyPair + ", primaryFxSpotRateSource=" + this.primaryFxSpotRateSource + ", secondaryFxSpotRateSource=" + this.secondaryFxSpotRateSource + '}' + " " + super.toString();
        }
    }
}

