/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.IndexBase;
import cdm.observable.asset.meta.CreditIndexMeta;
import cdm.product.asset.CreditSeniorityEnum;
import cdm.product.asset.IndexAnnexSourceEnum;
import cdm.product.asset.ReferenceInformation;
import cdm.product.asset.SettledEntityMatrix;
import cdm.product.asset.Tranche;
import cdm.product.asset.metafields.FieldWithMetaIndexAnnexSourceEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditIndex", builder=CreditIndexBuilderImpl.class, version="6.10.0")
@RuneDataType(value="CreditIndex", model="cdm", builder=CreditIndexBuilderImpl.class, version="6.10.0")
public interface CreditIndex
extends IndexBase,
GlobalKey {
    public static final CreditIndexMeta metaData = new CreditIndexMeta();

    public Integer getIndexSeries();

    public Integer getIndexAnnexVersion();

    public Date getIndexAnnexDate();

    public FieldWithMetaIndexAnnexSourceEnum getIndexAnnexSource();

    public List<? extends ReferenceInformation> getExcludedReferenceEntity();

    public Tranche getTranche();

    public SettledEntityMatrix getSettledEntityMatrix();

    public BigDecimal getIndexFactor();

    public CreditSeniorityEnum getSeniority();

    public MetaFields getMeta();

    @Override
    public CreditIndex build();

    @Override
    public CreditIndexBuilder toBuilder();

    public static CreditIndexBuilder builder() {
        return new CreditIndexBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditIndex> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditIndex> getType() {
        return CreditIndex.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.class, this.getName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.class, this.getProvider(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexSeries"), Integer.class, (Object)this.getIndexSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexAnnexVersion"), Integer.class, (Object)this.getIndexAnnexVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexAnnexDate"), Date.class, (Object)this.getIndexAnnexDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexAnnexSource"), processor, FieldWithMetaIndexAnnexSourceEnum.class, this.getIndexAnnexSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("excludedReferenceEntity"), processor, ReferenceInformation.class, this.getExcludedReferenceEntity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tranche"), processor, Tranche.class, this.getTranche(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settledEntityMatrix"), processor, SettledEntityMatrix.class, this.getSettledEntityMatrix(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seniority"), CreditSeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class CreditIndexBuilderImpl
    extends IndexBase.IndexBaseBuilderImpl
    implements CreditIndexBuilder {
        protected Integer indexSeries;
        protected Integer indexAnnexVersion;
        protected Date indexAnnexDate;
        protected FieldWithMetaIndexAnnexSourceEnum.FieldWithMetaIndexAnnexSourceEnumBuilder indexAnnexSource;
        protected List<ReferenceInformation.ReferenceInformationBuilder> excludedReferenceEntity = new ArrayList<ReferenceInformation.ReferenceInformationBuilder>();
        protected Tranche.TrancheBuilder tranche;
        protected SettledEntityMatrix.SettledEntityMatrixBuilder settledEntityMatrix;
        protected BigDecimal indexFactor;
        protected CreditSeniorityEnum seniority;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="indexSeries")
        @RuneAttribute(value="indexSeries")
        public Integer getIndexSeries() {
            return this.indexSeries;
        }

        @Override
        @RosettaAttribute(value="indexAnnexVersion")
        @RuneAttribute(value="indexAnnexVersion")
        public Integer getIndexAnnexVersion() {
            return this.indexAnnexVersion;
        }

        @Override
        @RosettaAttribute(value="indexAnnexDate")
        @RuneAttribute(value="indexAnnexDate")
        public Date getIndexAnnexDate() {
            return this.indexAnnexDate;
        }

        @Override
        @RosettaAttribute(value="indexAnnexSource")
        @RuneAttribute(value="indexAnnexSource")
        public FieldWithMetaIndexAnnexSourceEnum.FieldWithMetaIndexAnnexSourceEnumBuilder getIndexAnnexSource() {
            return this.indexAnnexSource;
        }

        @Override
        public FieldWithMetaIndexAnnexSourceEnum.FieldWithMetaIndexAnnexSourceEnumBuilder getOrCreateIndexAnnexSource() {
            FieldWithMetaIndexAnnexSourceEnum.FieldWithMetaIndexAnnexSourceEnumBuilder result = this.indexAnnexSource != null ? this.indexAnnexSource : (this.indexAnnexSource = FieldWithMetaIndexAnnexSourceEnum.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="excludedReferenceEntity")
        @RuneAttribute(value="excludedReferenceEntity")
        public List<? extends ReferenceInformation.ReferenceInformationBuilder> getExcludedReferenceEntity() {
            return this.excludedReferenceEntity;
        }

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getOrCreateExcludedReferenceEntity(int index) {
            if (this.excludedReferenceEntity == null) {
                this.excludedReferenceEntity = new ArrayList<ReferenceInformation.ReferenceInformationBuilder>();
            }
            return (ReferenceInformation.ReferenceInformationBuilder)this.getIndex(this.excludedReferenceEntity, index, () -> {
                ReferenceInformation.ReferenceInformationBuilder newExcludedReferenceEntity = ReferenceInformation.builder();
                return newExcludedReferenceEntity;
            });
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public Tranche.TrancheBuilder getTranche() {
            return this.tranche;
        }

        @Override
        public Tranche.TrancheBuilder getOrCreateTranche() {
            Tranche.TrancheBuilder result = this.tranche != null ? this.tranche : (this.tranche = Tranche.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settledEntityMatrix")
        @RuneAttribute(value="settledEntityMatrix")
        public SettledEntityMatrix.SettledEntityMatrixBuilder getSettledEntityMatrix() {
            return this.settledEntityMatrix;
        }

        @Override
        public SettledEntityMatrix.SettledEntityMatrixBuilder getOrCreateSettledEntityMatrix() {
            SettledEntityMatrix.SettledEntityMatrixBuilder result = this.settledEntityMatrix != null ? this.settledEntityMatrix : (this.settledEntityMatrix = SettledEntityMatrix.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniorityEnum getSeniority() {
            return this.seniority;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public CreditIndexBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public CreditIndexBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public CreditIndexBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public CreditIndexBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public CreditIndexBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public CreditIndexBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public CreditIndexBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public CreditIndexBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public CreditIndexBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public CreditIndexBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public CreditIndexBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public CreditIndexBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public CreditIndexBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public CreditIndexBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public CreditIndexBuilder setName(FieldWithMetaString _name) {
            this.name = _name == null ? null : _name.toBuilder();
            return this;
        }

        @Override
        public CreditIndexBuilder setNameValue(String _name) {
            this.getOrCreateName().setValue(_name);
            return this;
        }

        @Override
        @RosettaAttribute(value="provider")
        @RuneAttribute(value="provider")
        public CreditIndexBuilder setProvider(LegalEntity _provider) {
            this.provider = _provider == null ? null : _provider.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public CreditIndexBuilder setAssetClass(AssetClassEnum _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexSeries")
        @RuneAttribute(value="indexSeries")
        public CreditIndexBuilder setIndexSeries(Integer _indexSeries) {
            this.indexSeries = _indexSeries == null ? null : _indexSeries;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexAnnexVersion")
        @RuneAttribute(value="indexAnnexVersion")
        public CreditIndexBuilder setIndexAnnexVersion(Integer _indexAnnexVersion) {
            this.indexAnnexVersion = _indexAnnexVersion == null ? null : _indexAnnexVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexAnnexDate")
        @RuneAttribute(value="indexAnnexDate")
        public CreditIndexBuilder setIndexAnnexDate(Date _indexAnnexDate) {
            this.indexAnnexDate = _indexAnnexDate == null ? null : _indexAnnexDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexAnnexSource")
        @RuneAttribute(value="indexAnnexSource")
        public CreditIndexBuilder setIndexAnnexSource(FieldWithMetaIndexAnnexSourceEnum _indexAnnexSource) {
            this.indexAnnexSource = _indexAnnexSource == null ? null : _indexAnnexSource.toBuilder();
            return this;
        }

        @Override
        public CreditIndexBuilder setIndexAnnexSourceValue(IndexAnnexSourceEnum _indexAnnexSource) {
            this.getOrCreateIndexAnnexSource().setValue(_indexAnnexSource);
            return this;
        }

        @Override
        @RosettaAttribute(value="excludedReferenceEntity")
        @RuneAttribute(value="excludedReferenceEntity")
        public CreditIndexBuilder addExcludedReferenceEntity(ReferenceInformation _excludedReferenceEntity) {
            if (_excludedReferenceEntity != null) {
                this.excludedReferenceEntity.add(_excludedReferenceEntity.toBuilder());
            }
            return this;
        }

        @Override
        public CreditIndexBuilder addExcludedReferenceEntity(ReferenceInformation _excludedReferenceEntity, int idx) {
            this.getIndex(this.excludedReferenceEntity, idx, () -> _excludedReferenceEntity.toBuilder());
            return this;
        }

        @Override
        public CreditIndexBuilder addExcludedReferenceEntity(List<? extends ReferenceInformation> excludedReferenceEntitys) {
            if (excludedReferenceEntitys != null) {
                for (ReferenceInformation referenceInformation : excludedReferenceEntitys) {
                    this.excludedReferenceEntity.add(referenceInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="excludedReferenceEntity")
        public CreditIndexBuilder setExcludedReferenceEntity(List<? extends ReferenceInformation> excludedReferenceEntitys) {
            this.excludedReferenceEntity = excludedReferenceEntitys == null ? new ArrayList<ReferenceInformation.ReferenceInformationBuilder>() : (List)excludedReferenceEntitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public CreditIndexBuilder setTranche(Tranche _tranche) {
            this.tranche = _tranche == null ? null : _tranche.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settledEntityMatrix")
        @RuneAttribute(value="settledEntityMatrix")
        public CreditIndexBuilder setSettledEntityMatrix(SettledEntityMatrix _settledEntityMatrix) {
            this.settledEntityMatrix = _settledEntityMatrix == null ? null : _settledEntityMatrix.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public CreditIndexBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditIndexBuilder setSeniority(CreditSeniorityEnum _seniority) {
            this.seniority = _seniority == null ? null : _seniority;
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public CreditIndexBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public CreditIndex build() {
            return new CreditIndexImpl(this);
        }

        @Override
        public CreditIndexBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditIndexBuilder prune() {
            super.prune();
            if (this.indexAnnexSource != null && !this.indexAnnexSource.prune().hasData()) {
                this.indexAnnexSource = null;
            }
            this.excludedReferenceEntity = this.excludedReferenceEntity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.tranche != null && !this.tranche.prune().hasData()) {
                this.tranche = null;
            }
            if (this.settledEntityMatrix != null && !this.settledEntityMatrix.prune().hasData()) {
                this.settledEntityMatrix = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getIndexSeries() != null) {
                return true;
            }
            if (this.getIndexAnnexVersion() != null) {
                return true;
            }
            if (this.getIndexAnnexDate() != null) {
                return true;
            }
            if (this.getIndexAnnexSource() != null) {
                return true;
            }
            if (this.getExcludedReferenceEntity() != null && this.getExcludedReferenceEntity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTranche() != null && this.getTranche().hasData()) {
                return true;
            }
            if (this.getSettledEntityMatrix() != null && this.getSettledEntityMatrix().hasData()) {
                return true;
            }
            if (this.getIndexFactor() != null) {
                return true;
            }
            return this.getSeniority() != null;
        }

        @Override
        public CreditIndexBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CreditIndexBuilder o = (CreditIndexBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexAnnexSource(), (RosettaModelObjectBuilder)o.getIndexAnnexSource(), this::setIndexAnnexSource);
            merger.mergeRosetta(this.getExcludedReferenceEntity(), o.getExcludedReferenceEntity(), this::getOrCreateExcludedReferenceEntity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTranche(), (RosettaModelObjectBuilder)o.getTranche(), this::setTranche);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettledEntityMatrix(), (RosettaModelObjectBuilder)o.getSettledEntityMatrix(), this::setSettledEntityMatrix);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getIndexSeries(), (Object)o.getIndexSeries(), this::setIndexSeries, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexAnnexVersion(), (Object)o.getIndexAnnexVersion(), this::setIndexAnnexVersion, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexAnnexDate(), (Object)o.getIndexAnnexDate(), this::setIndexAnnexDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexFactor(), (Object)o.getIndexFactor(), this::setIndexFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSeniority(), (Object)o.getSeniority(), this::setSeniority, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditIndex _that = (CreditIndex)this.getType().cast(o);
            if (!Objects.equals(this.indexSeries, _that.getIndexSeries())) {
                return false;
            }
            if (!Objects.equals(this.indexAnnexVersion, _that.getIndexAnnexVersion())) {
                return false;
            }
            if (!Objects.equals(this.indexAnnexDate, _that.getIndexAnnexDate())) {
                return false;
            }
            if (!Objects.equals(this.indexAnnexSource, _that.getIndexAnnexSource())) {
                return false;
            }
            if (!ListEquals.listEquals(this.excludedReferenceEntity, _that.getExcludedReferenceEntity())) {
                return false;
            }
            if (!Objects.equals(this.tranche, _that.getTranche())) {
                return false;
            }
            if (!Objects.equals(this.settledEntityMatrix, _that.getSettledEntityMatrix())) {
                return false;
            }
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            if (!Objects.equals((Object)this.seniority, (Object)_that.getSeniority())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.indexSeries != null ? this.indexSeries.hashCode() : 0);
            _result = 31 * _result + (this.indexAnnexVersion != null ? this.indexAnnexVersion.hashCode() : 0);
            _result = 31 * _result + (this.indexAnnexDate != null ? this.indexAnnexDate.hashCode() : 0);
            _result = 31 * _result + (this.indexAnnexSource != null ? this.indexAnnexSource.hashCode() : 0);
            _result = 31 * _result + (this.excludedReferenceEntity != null ? this.excludedReferenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            _result = 31 * _result + (this.settledEntityMatrix != null ? this.settledEntityMatrix.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? ((Object)((Object)this.seniority)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditIndexBuilder {indexSeries=" + this.indexSeries + ", indexAnnexVersion=" + this.indexAnnexVersion + ", indexAnnexDate=" + this.indexAnnexDate + ", indexAnnexSource=" + this.indexAnnexSource + ", excludedReferenceEntity=" + this.excludedReferenceEntity + ", tranche=" + this.tranche + ", settledEntityMatrix=" + this.settledEntityMatrix + ", indexFactor=" + this.indexFactor + ", seniority=" + (Object)((Object)this.seniority) + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface CreditIndexBuilder
    extends CreditIndex,
    IndexBase.IndexBaseBuilder,
    GlobalKey.GlobalKeyBuilder {
        public FieldWithMetaIndexAnnexSourceEnum.FieldWithMetaIndexAnnexSourceEnumBuilder getOrCreateIndexAnnexSource();

        @Override
        public FieldWithMetaIndexAnnexSourceEnum.FieldWithMetaIndexAnnexSourceEnumBuilder getIndexAnnexSource();

        public ReferenceInformation.ReferenceInformationBuilder getOrCreateExcludedReferenceEntity(int var1);

        public List<? extends ReferenceInformation.ReferenceInformationBuilder> getExcludedReferenceEntity();

        public Tranche.TrancheBuilder getOrCreateTranche();

        @Override
        public Tranche.TrancheBuilder getTranche();

        public SettledEntityMatrix.SettledEntityMatrixBuilder getOrCreateSettledEntityMatrix();

        @Override
        public SettledEntityMatrix.SettledEntityMatrixBuilder getSettledEntityMatrix();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        @Override
        public CreditIndexBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public CreditIndexBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public CreditIndexBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public CreditIndexBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public CreditIndexBuilder addTaxonomy(Taxonomy var1);

        @Override
        public CreditIndexBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public CreditIndexBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public CreditIndexBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public CreditIndexBuilder setIsExchangeListed(Boolean var1);

        @Override
        public CreditIndexBuilder setExchange(LegalEntity var1);

        @Override
        public CreditIndexBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public CreditIndexBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public CreditIndexBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public CreditIndexBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public CreditIndexBuilder setName(FieldWithMetaString var1);

        @Override
        public CreditIndexBuilder setNameValue(String var1);

        @Override
        public CreditIndexBuilder setProvider(LegalEntity var1);

        @Override
        public CreditIndexBuilder setAssetClass(AssetClassEnum var1);

        public CreditIndexBuilder setIndexSeries(Integer var1);

        public CreditIndexBuilder setIndexAnnexVersion(Integer var1);

        public CreditIndexBuilder setIndexAnnexDate(Date var1);

        public CreditIndexBuilder setIndexAnnexSource(FieldWithMetaIndexAnnexSourceEnum var1);

        public CreditIndexBuilder setIndexAnnexSourceValue(IndexAnnexSourceEnum var1);

        public CreditIndexBuilder addExcludedReferenceEntity(ReferenceInformation var1);

        public CreditIndexBuilder addExcludedReferenceEntity(ReferenceInformation var1, int var2);

        public CreditIndexBuilder addExcludedReferenceEntity(List<? extends ReferenceInformation> var1);

        public CreditIndexBuilder setExcludedReferenceEntity(List<? extends ReferenceInformation> var1);

        public CreditIndexBuilder setTranche(Tranche var1);

        public CreditIndexBuilder setSettledEntityMatrix(SettledEntityMatrix var1);

        public CreditIndexBuilder setIndexFactor(BigDecimal var1);

        public CreditIndexBuilder setSeniority(CreditSeniorityEnum var1);

        public CreditIndexBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, (RosettaModelObjectBuilder)this.getName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getProvider(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexSeries"), Integer.class, (Object)this.getIndexSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexAnnexVersion"), Integer.class, (Object)this.getIndexAnnexVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexAnnexDate"), Date.class, (Object)this.getIndexAnnexDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexAnnexSource"), processor, FieldWithMetaIndexAnnexSourceEnum.FieldWithMetaIndexAnnexSourceEnumBuilder.class, this.getIndexAnnexSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("excludedReferenceEntity"), processor, ReferenceInformation.ReferenceInformationBuilder.class, this.getExcludedReferenceEntity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tranche"), processor, Tranche.TrancheBuilder.class, this.getTranche(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settledEntityMatrix"), processor, SettledEntityMatrix.SettledEntityMatrixBuilder.class, this.getSettledEntityMatrix(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seniority"), CreditSeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public CreditIndexBuilder prune();
    }

    public static class CreditIndexImpl
    extends IndexBase.IndexBaseImpl
    implements CreditIndex {
        private final Integer indexSeries;
        private final Integer indexAnnexVersion;
        private final Date indexAnnexDate;
        private final FieldWithMetaIndexAnnexSourceEnum indexAnnexSource;
        private final List<? extends ReferenceInformation> excludedReferenceEntity;
        private final Tranche tranche;
        private final SettledEntityMatrix settledEntityMatrix;
        private final BigDecimal indexFactor;
        private final CreditSeniorityEnum seniority;
        private final MetaFields meta;

        protected CreditIndexImpl(CreditIndexBuilder builder) {
            super(builder);
            this.indexSeries = builder.getIndexSeries();
            this.indexAnnexVersion = builder.getIndexAnnexVersion();
            this.indexAnnexDate = builder.getIndexAnnexDate();
            this.indexAnnexSource = Optional.ofNullable(builder.getIndexAnnexSource()).map(f -> f.build()).orElse(null);
            this.excludedReferenceEntity = Optional.ofNullable(builder.getExcludedReferenceEntity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tranche = Optional.ofNullable(builder.getTranche()).map(f -> f.build()).orElse(null);
            this.settledEntityMatrix = Optional.ofNullable(builder.getSettledEntityMatrix()).map(f -> f.build()).orElse(null);
            this.indexFactor = builder.getIndexFactor();
            this.seniority = builder.getSeniority();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="indexSeries")
        @RuneAttribute(value="indexSeries")
        public Integer getIndexSeries() {
            return this.indexSeries;
        }

        @Override
        @RosettaAttribute(value="indexAnnexVersion")
        @RuneAttribute(value="indexAnnexVersion")
        public Integer getIndexAnnexVersion() {
            return this.indexAnnexVersion;
        }

        @Override
        @RosettaAttribute(value="indexAnnexDate")
        @RuneAttribute(value="indexAnnexDate")
        public Date getIndexAnnexDate() {
            return this.indexAnnexDate;
        }

        @Override
        @RosettaAttribute(value="indexAnnexSource")
        @RuneAttribute(value="indexAnnexSource")
        public FieldWithMetaIndexAnnexSourceEnum getIndexAnnexSource() {
            return this.indexAnnexSource;
        }

        @Override
        @RosettaAttribute(value="excludedReferenceEntity")
        @RuneAttribute(value="excludedReferenceEntity")
        public List<? extends ReferenceInformation> getExcludedReferenceEntity() {
            return this.excludedReferenceEntity;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public Tranche getTranche() {
            return this.tranche;
        }

        @Override
        @RosettaAttribute(value="settledEntityMatrix")
        @RuneAttribute(value="settledEntityMatrix")
        public SettledEntityMatrix getSettledEntityMatrix() {
            return this.settledEntityMatrix;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniorityEnum getSeniority() {
            return this.seniority;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public CreditIndex build() {
            return this;
        }

        @Override
        public CreditIndexBuilder toBuilder() {
            CreditIndexBuilder builder = CreditIndex.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditIndexBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getIndexSeries()).ifPresent(builder::setIndexSeries);
            Optional.ofNullable(this.getIndexAnnexVersion()).ifPresent(builder::setIndexAnnexVersion);
            Optional.ofNullable(this.getIndexAnnexDate()).ifPresent(builder::setIndexAnnexDate);
            Optional.ofNullable(this.getIndexAnnexSource()).ifPresent(builder::setIndexAnnexSource);
            Optional.ofNullable(this.getExcludedReferenceEntity()).ifPresent(builder::setExcludedReferenceEntity);
            Optional.ofNullable(this.getTranche()).ifPresent(builder::setTranche);
            Optional.ofNullable(this.getSettledEntityMatrix()).ifPresent(builder::setSettledEntityMatrix);
            Optional.ofNullable(this.getIndexFactor()).ifPresent(builder::setIndexFactor);
            Optional.ofNullable(this.getSeniority()).ifPresent(builder::setSeniority);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditIndex _that = (CreditIndex)this.getType().cast(o);
            if (!Objects.equals(this.indexSeries, _that.getIndexSeries())) {
                return false;
            }
            if (!Objects.equals(this.indexAnnexVersion, _that.getIndexAnnexVersion())) {
                return false;
            }
            if (!Objects.equals(this.indexAnnexDate, _that.getIndexAnnexDate())) {
                return false;
            }
            if (!Objects.equals(this.indexAnnexSource, _that.getIndexAnnexSource())) {
                return false;
            }
            if (!ListEquals.listEquals(this.excludedReferenceEntity, _that.getExcludedReferenceEntity())) {
                return false;
            }
            if (!Objects.equals(this.tranche, _that.getTranche())) {
                return false;
            }
            if (!Objects.equals(this.settledEntityMatrix, _that.getSettledEntityMatrix())) {
                return false;
            }
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            if (!Objects.equals((Object)this.seniority, (Object)_that.getSeniority())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.indexSeries != null ? this.indexSeries.hashCode() : 0);
            _result = 31 * _result + (this.indexAnnexVersion != null ? this.indexAnnexVersion.hashCode() : 0);
            _result = 31 * _result + (this.indexAnnexDate != null ? this.indexAnnexDate.hashCode() : 0);
            _result = 31 * _result + (this.indexAnnexSource != null ? this.indexAnnexSource.hashCode() : 0);
            _result = 31 * _result + (this.excludedReferenceEntity != null ? this.excludedReferenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            _result = 31 * _result + (this.settledEntityMatrix != null ? this.settledEntityMatrix.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? ((Object)((Object)this.seniority)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditIndex {indexSeries=" + this.indexSeries + ", indexAnnexVersion=" + this.indexAnnexVersion + ", indexAnnexDate=" + this.indexAnnexDate + ", indexAnnexSource=" + this.indexAnnexSource + ", excludedReferenceEntity=" + this.excludedReferenceEntity + ", tranche=" + this.tranche + ", settledEntityMatrix=" + this.settledEntityMatrix + ", indexFactor=" + this.indexFactor + ", seniority=" + (Object)((Object)this.seniority) + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }
}

