/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.Party;
import cdm.legaldocumentation.common.CreditSupportDocumentTermsEnum;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.csa.meta.CreditSupportDocumentElectionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditSupportDocumentElection", builder=CreditSupportDocumentElectionBuilderImpl.class, version="6.10.0")
@RuneDataType(value="CreditSupportDocumentElection", model="cdm", builder=CreditSupportDocumentElectionBuilderImpl.class, version="6.10.0")
public interface CreditSupportDocumentElection
extends RosettaModelObject {
    public static final CreditSupportDocumentElectionMeta metaData = new CreditSupportDocumentElectionMeta();

    public Party getParty();

    public CreditSupportDocumentTermsEnum getCreditSupportDocumentTerms();

    public List<? extends LegalAgreement> getCreditSupportDocument();

    public String getBespokeCreditSuppportDocument();

    public CreditSupportDocumentElection build();

    public CreditSupportDocumentElectionBuilder toBuilder();

    public static CreditSupportDocumentElectionBuilder builder() {
        return new CreditSupportDocumentElectionBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditSupportDocumentElection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditSupportDocumentElection> getType() {
        return CreditSupportDocumentElection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditSupportDocumentTerms"), CreditSupportDocumentTermsEnum.class, (Object)this.getCreditSupportDocumentTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditSupportDocument"), processor, LegalAgreement.class, this.getCreditSupportDocument(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bespokeCreditSuppportDocument"), String.class, (Object)this.getBespokeCreditSuppportDocument(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CreditSupportDocumentElectionBuilderImpl
    implements CreditSupportDocumentElectionBuilder {
        protected Party.PartyBuilder party;
        protected CreditSupportDocumentTermsEnum creditSupportDocumentTerms;
        protected List<LegalAgreement.LegalAgreementBuilder> creditSupportDocument = new ArrayList<LegalAgreement.LegalAgreementBuilder>();
        protected String bespokeCreditSuppportDocument;

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public Party.PartyBuilder getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty() {
            Party.PartyBuilder result = this.party != null ? this.party : (this.party = Party.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditSupportDocumentTerms", isRequired=true)
        @RuneAttribute(value="creditSupportDocumentTerms", isRequired=true)
        public CreditSupportDocumentTermsEnum getCreditSupportDocumentTerms() {
            return this.creditSupportDocumentTerms;
        }

        @Override
        @RosettaAttribute(value="creditSupportDocument")
        @RuneAttribute(value="creditSupportDocument")
        public List<? extends LegalAgreement.LegalAgreementBuilder> getCreditSupportDocument() {
            return this.creditSupportDocument;
        }

        @Override
        public LegalAgreement.LegalAgreementBuilder getOrCreateCreditSupportDocument(int index) {
            if (this.creditSupportDocument == null) {
                this.creditSupportDocument = new ArrayList<LegalAgreement.LegalAgreementBuilder>();
            }
            return (LegalAgreement.LegalAgreementBuilder)this.getIndex(this.creditSupportDocument, index, () -> {
                LegalAgreement.LegalAgreementBuilder newCreditSupportDocument = LegalAgreement.builder();
                return newCreditSupportDocument;
            });
        }

        @Override
        @RosettaAttribute(value="bespokeCreditSuppportDocument")
        @RuneAttribute(value="bespokeCreditSuppportDocument")
        public String getBespokeCreditSuppportDocument() {
            return this.bespokeCreditSuppportDocument;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CreditSupportDocumentElectionBuilder setParty(Party _party) {
            this.party = _party == null ? null : _party.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportDocumentTerms", isRequired=true)
        @RuneAttribute(value="creditSupportDocumentTerms", isRequired=true)
        public CreditSupportDocumentElectionBuilder setCreditSupportDocumentTerms(CreditSupportDocumentTermsEnum _creditSupportDocumentTerms) {
            this.creditSupportDocumentTerms = _creditSupportDocumentTerms == null ? null : _creditSupportDocumentTerms;
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportDocument")
        @RuneAttribute(value="creditSupportDocument")
        public CreditSupportDocumentElectionBuilder addCreditSupportDocument(LegalAgreement _creditSupportDocument) {
            if (_creditSupportDocument != null) {
                this.creditSupportDocument.add(_creditSupportDocument.toBuilder());
            }
            return this;
        }

        @Override
        public CreditSupportDocumentElectionBuilder addCreditSupportDocument(LegalAgreement _creditSupportDocument, int idx) {
            this.getIndex(this.creditSupportDocument, idx, () -> _creditSupportDocument.toBuilder());
            return this;
        }

        @Override
        public CreditSupportDocumentElectionBuilder addCreditSupportDocument(List<? extends LegalAgreement> creditSupportDocuments) {
            if (creditSupportDocuments != null) {
                for (LegalAgreement legalAgreement : creditSupportDocuments) {
                    this.creditSupportDocument.add(legalAgreement.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditSupportDocument")
        public CreditSupportDocumentElectionBuilder setCreditSupportDocument(List<? extends LegalAgreement> creditSupportDocuments) {
            this.creditSupportDocument = creditSupportDocuments == null ? new ArrayList<LegalAgreement.LegalAgreementBuilder>() : (List)creditSupportDocuments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="bespokeCreditSuppportDocument")
        @RuneAttribute(value="bespokeCreditSuppportDocument")
        public CreditSupportDocumentElectionBuilder setBespokeCreditSuppportDocument(String _bespokeCreditSuppportDocument) {
            this.bespokeCreditSuppportDocument = _bespokeCreditSuppportDocument == null ? null : _bespokeCreditSuppportDocument;
            return this;
        }

        @Override
        public CreditSupportDocumentElection build() {
            return new CreditSupportDocumentElectionImpl(this);
        }

        @Override
        public CreditSupportDocumentElectionBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditSupportDocumentElectionBuilder prune() {
            if (this.party != null && !this.party.prune().hasData()) {
                this.party = null;
            }
            this.creditSupportDocument = this.creditSupportDocument.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null && this.getParty().hasData()) {
                return true;
            }
            if (this.getCreditSupportDocumentTerms() != null) {
                return true;
            }
            if (this.getCreditSupportDocument() != null && this.getCreditSupportDocument().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getBespokeCreditSuppportDocument() != null;
        }

        public CreditSupportDocumentElectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditSupportDocumentElectionBuilder o = (CreditSupportDocumentElectionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getParty(), (RosettaModelObjectBuilder)o.getParty(), this::setParty);
            merger.mergeRosetta(this.getCreditSupportDocument(), o.getCreditSupportDocument(), this::getOrCreateCreditSupportDocument);
            merger.mergeBasic((Object)this.getCreditSupportDocumentTerms(), (Object)o.getCreditSupportDocumentTerms(), this::setCreditSupportDocumentTerms, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBespokeCreditSuppportDocument(), (Object)o.getBespokeCreditSuppportDocument(), this::setBespokeCreditSuppportDocument, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditSupportDocumentElection _that = this.getType().cast(o);
            if (!Objects.equals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.creditSupportDocumentTerms, (Object)_that.getCreditSupportDocumentTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditSupportDocument, _that.getCreditSupportDocument())) {
                return false;
            }
            return Objects.equals(this.bespokeCreditSuppportDocument, _that.getBespokeCreditSuppportDocument());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportDocumentTerms != null ? ((Object)((Object)this.creditSupportDocumentTerms)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditSupportDocument != null ? this.creditSupportDocument.hashCode() : 0);
            _result = 31 * _result + (this.bespokeCreditSuppportDocument != null ? this.bespokeCreditSuppportDocument.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditSupportDocumentElectionBuilder {party=" + this.party + ", creditSupportDocumentTerms=" + (Object)((Object)this.creditSupportDocumentTerms) + ", creditSupportDocument=" + this.creditSupportDocument + ", bespokeCreditSuppportDocument=" + this.bespokeCreditSuppportDocument + '}';
        }
    }

    public static interface CreditSupportDocumentElectionBuilder
    extends CreditSupportDocumentElection,
    RosettaModelObjectBuilder {
        public Party.PartyBuilder getOrCreateParty();

        @Override
        public Party.PartyBuilder getParty();

        public LegalAgreement.LegalAgreementBuilder getOrCreateCreditSupportDocument(int var1);

        public List<? extends LegalAgreement.LegalAgreementBuilder> getCreditSupportDocument();

        public CreditSupportDocumentElectionBuilder setParty(Party var1);

        public CreditSupportDocumentElectionBuilder setCreditSupportDocumentTerms(CreditSupportDocumentTermsEnum var1);

        public CreditSupportDocumentElectionBuilder addCreditSupportDocument(LegalAgreement var1);

        public CreditSupportDocumentElectionBuilder addCreditSupportDocument(LegalAgreement var1, int var2);

        public CreditSupportDocumentElectionBuilder addCreditSupportDocument(List<? extends LegalAgreement> var1);

        public CreditSupportDocumentElectionBuilder setCreditSupportDocument(List<? extends LegalAgreement> var1);

        public CreditSupportDocumentElectionBuilder setBespokeCreditSuppportDocument(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditSupportDocumentTerms"), CreditSupportDocumentTermsEnum.class, (Object)this.getCreditSupportDocumentTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditSupportDocument"), processor, LegalAgreement.LegalAgreementBuilder.class, this.getCreditSupportDocument(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bespokeCreditSuppportDocument"), String.class, (Object)this.getBespokeCreditSuppportDocument(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CreditSupportDocumentElectionBuilder prune();
    }

    public static class CreditSupportDocumentElectionImpl
    implements CreditSupportDocumentElection {
        private final Party party;
        private final CreditSupportDocumentTermsEnum creditSupportDocumentTerms;
        private final List<? extends LegalAgreement> creditSupportDocument;
        private final String bespokeCreditSuppportDocument;

        protected CreditSupportDocumentElectionImpl(CreditSupportDocumentElectionBuilder builder) {
            this.party = Optional.ofNullable(builder.getParty()).map(f -> f.build()).orElse(null);
            this.creditSupportDocumentTerms = builder.getCreditSupportDocumentTerms();
            this.creditSupportDocument = Optional.ofNullable(builder.getCreditSupportDocument()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.bespokeCreditSuppportDocument = builder.getBespokeCreditSuppportDocument();
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public Party getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="creditSupportDocumentTerms", isRequired=true)
        @RuneAttribute(value="creditSupportDocumentTerms", isRequired=true)
        public CreditSupportDocumentTermsEnum getCreditSupportDocumentTerms() {
            return this.creditSupportDocumentTerms;
        }

        @Override
        @RosettaAttribute(value="creditSupportDocument")
        @RuneAttribute(value="creditSupportDocument")
        public List<? extends LegalAgreement> getCreditSupportDocument() {
            return this.creditSupportDocument;
        }

        @Override
        @RosettaAttribute(value="bespokeCreditSuppportDocument")
        @RuneAttribute(value="bespokeCreditSuppportDocument")
        public String getBespokeCreditSuppportDocument() {
            return this.bespokeCreditSuppportDocument;
        }

        @Override
        public CreditSupportDocumentElection build() {
            return this;
        }

        @Override
        public CreditSupportDocumentElectionBuilder toBuilder() {
            CreditSupportDocumentElectionBuilder builder = CreditSupportDocumentElection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditSupportDocumentElectionBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getCreditSupportDocumentTerms()).ifPresent(builder::setCreditSupportDocumentTerms);
            Optional.ofNullable(this.getCreditSupportDocument()).ifPresent(builder::setCreditSupportDocument);
            Optional.ofNullable(this.getBespokeCreditSuppportDocument()).ifPresent(builder::setBespokeCreditSuppportDocument);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditSupportDocumentElection _that = this.getType().cast(o);
            if (!Objects.equals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.creditSupportDocumentTerms, (Object)_that.getCreditSupportDocumentTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditSupportDocument, _that.getCreditSupportDocument())) {
                return false;
            }
            return Objects.equals(this.bespokeCreditSuppportDocument, _that.getBespokeCreditSuppportDocument());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportDocumentTerms != null ? ((Object)((Object)this.creditSupportDocumentTerms)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditSupportDocument != null ? this.creditSupportDocument.hashCode() : 0);
            _result = 31 * _result + (this.bespokeCreditSuppportDocument != null ? this.bespokeCreditSuppportDocument.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditSupportDocumentElection {party=" + this.party + ", creditSupportDocumentTerms=" + (Object)((Object)this.creditSupportDocumentTerms) + ", creditSupportDocument=" + this.creditSupportDocument + ", bespokeCreditSuppportDocument=" + this.bespokeCreditSuppportDocument + '}';
        }
    }
}

