/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common.validation.datarule;

import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.LegalAgreementTypeEnum;
import cdm.product.collateral.CreditSupportAgreementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LegalAgreementAgreementVerification")
@ImplementedBy(value=Default.class)
public interface LegalAgreementAgreementVerification
extends Validator<LegalAgreement> {
    public static final String NAME = "LegalAgreementAgreementVerification";
    public static final String DEFINITION = "if agreementTerms -> agreement -> securityAgreementElections exists then legalAgreementIdentification -> agreementName -> agreementType = LegalAgreementTypeEnum -> SecurityAgreement else if agreementTerms -> agreement -> creditSupportAgreementElections exists then legalAgreementIdentification -> agreementName -> creditSupportAgreementType = CreditSupportAgreementTypeEnum -> CreditSupportAnnex or legalAgreementIdentification -> agreementName -> creditSupportAgreementType = CreditSupportAgreementTypeEnum -> CreditSupportDeed else if agreementTerms -> agreement -> collateralTransferAgreementElections exists then legalAgreementIdentification -> agreementName -> creditSupportAgreementType = CreditSupportAgreementTypeEnum -> CollateralTransferAgreement else if agreementTerms -> agreement -> masterAgreementSchedule exists then legalAgreementIdentification -> agreementName -> agreementType = LegalAgreementTypeEnum -> MasterAgreement";

    public static class NoOp
    implements LegalAgreementAgreementVerification {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegalAgreement legalAgreement) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LegalAgreementAgreementVerification {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegalAgreement legalAgreement) {
            ComparisonResult result = this.executeDataRule(legalAgreement);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LegalAgreementAgreementVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementAgreementVerification.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LegalAgreementAgreementVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementAgreementVerification.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LegalAgreement legalAgreement) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementTerms", _legalAgreement -> _legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getSecurityAgreementElections", agreement -> agreement.getSecurityAgreementElections())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", _legalAgreement -> _legalAgreement.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getAgreementType", agreementName -> agreementName.getAgreementType()), (Mapper)MapperS.of((Object)((Object)LegalAgreementTypeEnum.SECURITY_AGREEMENT)), (CardinalityOperator)CardinalityOperator.All);
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementTerms", _legalAgreement -> _legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getCreditSupportAgreementElections", agreement -> agreement.getCreditSupportAgreementElections())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", _legalAgreement -> _legalAgreement.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getCreditSupportAgreementType", agreementName -> agreementName.getCreditSupportAgreementType()).map("Type coercion", fieldWithMetaCreditSupportAgreementTypeEnum0 -> fieldWithMetaCreditSupportAgreementTypeEnum0 == null ? null : fieldWithMetaCreditSupportAgreementTypeEnum0.getValue()), (Mapper)MapperS.of((Object)((Object)CreditSupportAgreementTypeEnum.CREDIT_SUPPORT_ANNEX)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", _legalAgreement -> _legalAgreement.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getCreditSupportAgreementType", agreementName -> agreementName.getCreditSupportAgreementType()).map("Type coercion", fieldWithMetaCreditSupportAgreementTypeEnum1 -> fieldWithMetaCreditSupportAgreementTypeEnum1 == null ? null : fieldWithMetaCreditSupportAgreementTypeEnum1.getValue()), (Mapper)MapperS.of((Object)((Object)CreditSupportAgreementTypeEnum.CREDIT_SUPPORT_DEED)), (CardinalityOperator)CardinalityOperator.All));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementTerms", _legalAgreement -> _legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getCollateralTransferAgreementElections", agreement -> agreement.getCollateralTransferAgreementElections())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", _legalAgreement -> _legalAgreement.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getCreditSupportAgreementType", agreementName -> agreementName.getCreditSupportAgreementType()).map("Type coercion", fieldWithMetaCreditSupportAgreementTypeEnum2 -> fieldWithMetaCreditSupportAgreementTypeEnum2 == null ? null : fieldWithMetaCreditSupportAgreementTypeEnum2.getValue()), (Mapper)MapperS.of((Object)((Object)CreditSupportAgreementTypeEnum.COLLATERAL_TRANSFER_AGREEMENT)), (CardinalityOperator)CardinalityOperator.All);
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementTerms", _legalAgreement -> _legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getMasterAgreementSchedule", agreement -> agreement.getMasterAgreementSchedule())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", _legalAgreement -> _legalAgreement.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getAgreementType", agreementName -> agreementName.getAgreementType()), (Mapper)MapperS.of((Object)((Object)LegalAgreementTypeEnum.MASTER_AGREEMENT)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

