/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantity;
import cdm.base.math.Quantity;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.util.AssetDeepPathUtil;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.CalculateTransferInstruction;
import cdm.event.common.Transfer;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.functions.FilterPrice;
import cdm.product.template.AssetPayout;
import cdm.product.template.Payout;
import cdm.product.template.metafields.ReferenceWithMetaPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_AssetTransferDefault.class)
public abstract class Create_AssetTransfer
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AssetDeepPathUtil assetDeepPathUtil;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected FilterPrice filterPrice;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

    public Transfer evaluate(CalculateTransferInstruction instruction) {
        Transfer transfer;
        this.conditionValidator.validate(() -> {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity()).map("getUnit", quantity -> quantity.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All);
            }
            return ComparisonResult.successEmptyOperand((String)"");
        }, "");
        Transfer.TransferBuilder transferBuilder = this.doEvaluate(instruction);
        if (transferBuilder == null) {
            transfer = null;
        } else {
            transfer = transferBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)transfer);
        }
        return transfer;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(CalculateTransferInstruction var1);

    protected abstract MapperS<? extends Payout> payout(CalculateTransferInstruction var1);

    protected abstract MapperS<? extends AssetPayout> assetPayout(CalculateTransferInstruction var1);

    protected abstract MapperS<? extends QuantitySchedule> tradeQuantity(CalculateTransferInstruction var1);

    protected abstract MapperS<? extends Quantity> securityQuantity(CalculateTransferInstruction var1);

    protected abstract MapperS<? extends PriceSchedule> securityPrice(CalculateTransferInstruction var1);

    public static class Create_AssetTransferDefault
    extends Create_AssetTransfer {
        @Override
        protected Transfer.TransferBuilder doEvaluate(CalculateTransferInstruction instruction) {
            Transfer.TransferBuilder transfer = Transfer.builder();
            return this.assignOutput(transfer, instruction);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder transfer, CalculateTransferInstruction instruction) {
            transfer.setQuantity(NonNegativeQuantity.builder().setValue((BigDecimal)this.securityQuantity(instruction).map("getValue", quantity -> quantity.getValue()).get()).setUnit((UnitType)this.securityQuantity(instruction).map("getUnit", quantity -> quantity.getUnit()).get()).build());
            transfer.getOrCreateAsset().getOrCreateInstrument().getOrCreateSecurity().addIdentifier(this.assetPayout(instruction).map("getUnderlier", _assetPayout -> _assetPayout.getUnderlier()).mapC("chooseIdentifier", asset -> this.assetDeepPathUtil.chooseIdentifier((Asset)asset)).getMulti());
            ReferenceWithMetaParty ifThenElseResult0 = ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer())).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getCounterparty", trade -> trade.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get() : (ExpressionOperators.exists((Mapper)this.assetPayout(instruction).map("getPayerReceiver", _assetPayout -> _assetPayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer())).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getCounterparty", trade -> trade.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.assetPayout(instruction).map("getPayerReceiver", _assetPayout -> _assetPayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get() : ReferenceWithMetaParty.builder().build());
            transfer.getOrCreatePayerReceiver().setPayerPartyReference(ifThenElseResult0);
            ReferenceWithMetaParty ifThenElseResult1 = ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer())).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getCounterparty", trade -> trade.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get() : (ExpressionOperators.exists((Mapper)this.assetPayout(instruction).map("getPayerReceiver", _assetPayout -> _assetPayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver())).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getCounterparty", trade -> trade.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.assetPayout(instruction).map("getPayerReceiver", _assetPayout -> _assetPayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get() : ReferenceWithMetaParty.builder().build());
            transfer.getOrCreatePayerReceiver().setReceiverPartyReference(ifThenElseResult1);
            Date date = (Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get();
            transfer.getOrCreateSettlementDate().setAdjustedDate(date == null ? FieldWithMetaDate.builder().build() : FieldWithMetaDate.builder().setValue(date).build());
            Payout transferSettlementOrigin = (Payout)this.payout(instruction).get();
            transfer.setSettlementOrigin(ReferenceWithMetaPayout.builder().setGlobalReference(Optional.ofNullable(transferSettlementOrigin).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable(transferSettlementOrigin).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            return Optional.ofNullable(transfer).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Payout> payout(CalculateTransferInstruction instruction) {
            MapperC thenArg = MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getProduct", trade -> trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getAssetPayout", _payout -> _payout.getAssetPayout())).get());
            return MapperS.of((Object)((Payout)thenArg.get()));
        }

        @Override
        protected MapperS<? extends AssetPayout> assetPayout(CalculateTransferInstruction instruction) {
            return this.payout(instruction).map("getAssetPayout", _payout -> _payout.getAssetPayout());
        }

        @Override
        protected MapperS<? extends QuantitySchedule> tradeQuantity(CalculateTransferInstruction instruction) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getTradeLot", trade -> trade.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti(), FinancialUnitEnum.SHARE)).get()));
        }

        @Override
        protected MapperS<? extends Quantity> securityQuantity(CalculateTransferInstruction instruction) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity());
            }
            return MapperS.of((Object)NonNegativeQuantity.builder().setValue((BigDecimal)this.tradeQuantity(instruction).map("getValue", quantitySchedule -> quantitySchedule.getValue()).get()).setUnit((UnitType)this.tradeQuantity(instruction).map("getUnit", quantitySchedule -> quantitySchedule.getUnit()).get()).build());
        }

        @Override
        protected MapperS<? extends PriceSchedule> securityPrice(CalculateTransferInstruction instruction) {
            return MapperS.of((Object)this.filterPrice.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getTradeLot", trade -> trade.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti(), PriceTypeEnum.ASSET_PRICE, Collections.emptyList(), null));
        }
    }
}

