# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.qualification.functions.Qualify_EquitySwap_ParameterReturnVariance_Index import Qualify_EquitySwap_ParameterReturnVariance_Index
from cdm.product.template.EconomicTerms import EconomicTerms

__all__ = ['Qualify_EquityOption_ParameterReturnVariance_Index']


@replaceable
def Qualify_EquityOption_ParameterReturnVariance_Index(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as an Equity Variance Index Option.  The determination of the qualification is based on the economic terms and the following criteria: 1) The product contains a single option payout and 2) the underlying product is aan Index Equity Variance Swap
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    underlierEconomicTerms = get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "optionPayout"), "underlier"), "contractualProduct"), "economicTerms"))
    is_product =  (rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "optionPayout")) and all_elements(Qualify_EquitySwap_ParameterReturnVariance_Index(rosetta_resolve_attr(self, "underlierEconomicTerms")), "=", True))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
