/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.AssetPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AssetPayoutProductMustBeSecurity")
@ImplementedBy(value=Default.class)
public interface AssetPayoutProductMustBeSecurity
extends Validator<AssetPayout> {
    public static final String NAME = "AssetPayoutProductMustBeSecurity";
    public static final String DEFINITION = "securityInformation -> security exists";

    public static class NoOp
    implements AssetPayoutProductMustBeSecurity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetPayout assetPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AssetPayoutProductMustBeSecurity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetPayout assetPayout) {
            ComparisonResult result = this.executeDataRule(assetPayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AssetPayoutProductMustBeSecurity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutProductMustBeSecurity.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AssetPayoutProductMustBeSecurity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutProductMustBeSecurity.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AssetPayout assetPayout) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)assetPayout).map("getSecurityInformation", _assetPayout -> _assetPayout.getSecurityInformation()).map("getSecurity", product -> product.getSecurity()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

