/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.PeriodRange;
import cdm.base.staticdata.asset.common.AssetType;
import cdm.base.staticdata.asset.common.CollateralTaxonomy;
import cdm.base.staticdata.asset.common.CurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.MaturityTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.product.collateral.AgencyRatingCriteria;
import cdm.product.collateral.ListingType;
import cdm.product.collateral.meta.AssetCriteriaMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetCriteria", builder=AssetCriteriaBuilderImpl.class, version="5.28.0")
@RuneDataType(value="AssetCriteria", model="cdm", builder=AssetCriteriaBuilderImpl.class, version="5.28.0")
public interface AssetCriteria
extends RosettaModelObject {
    public static final AssetCriteriaMeta metaData = new AssetCriteriaMeta();

    public List<? extends AssetType> getCollateralAssetType();

    public List<ISOCountryCodeEnum> getAssetCountryOfOrigin();

    public List<CurrencyCodeEnum> getDenominatedCurrency();

    public List<? extends AgencyRatingCriteria> getAgencyRating();

    public MaturityTypeEnum getMaturityType();

    public PeriodRange getMaturityRange();

    public List<? extends ProductIdentifier> getProductIdentifier();

    public List<? extends CollateralTaxonomy> getCollateralTaxonomy();

    public Boolean getDomesticCurrencyIssued();

    public ListingType getListing();

    public AssetCriteria build();

    public AssetCriteriaBuilder toBuilder();

    public static AssetCriteriaBuilder builder() {
        return new AssetCriteriaBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetCriteria> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetCriteria> getType() {
        return AssetCriteria.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("collateralAssetType"), processor, AssetType.class, this.getCollateralAssetType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetCountryOfOrigin"), ISOCountryCodeEnum.class, this.getAssetCountryOfOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("denominatedCurrency"), CurrencyCodeEnum.class, this.getDenominatedCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agencyRating"), processor, AgencyRatingCriteria.class, this.getAgencyRating(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityType"), MaturityTypeEnum.class, (Object)this.getMaturityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("maturityRange"), processor, PeriodRange.class, this.getMaturityRange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productIdentifier"), processor, ProductIdentifier.class, this.getProductIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralTaxonomy"), processor, CollateralTaxonomy.class, this.getCollateralTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("domesticCurrencyIssued"), Boolean.class, (Object)this.getDomesticCurrencyIssued(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("listing"), processor, ListingType.class, this.getListing(), new AttributeMeta[0]);
    }

    public static class AssetCriteriaBuilderImpl
    implements AssetCriteriaBuilder {
        protected List<AssetType.AssetTypeBuilder> collateralAssetType = new ArrayList<AssetType.AssetTypeBuilder>();
        protected List<ISOCountryCodeEnum> assetCountryOfOrigin = new ArrayList<ISOCountryCodeEnum>();
        protected List<CurrencyCodeEnum> denominatedCurrency = new ArrayList<CurrencyCodeEnum>();
        protected List<AgencyRatingCriteria.AgencyRatingCriteriaBuilder> agencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
        protected MaturityTypeEnum maturityType;
        protected PeriodRange.PeriodRangeBuilder maturityRange;
        protected List<ProductIdentifier.ProductIdentifierBuilder> productIdentifier = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
        protected List<CollateralTaxonomy.CollateralTaxonomyBuilder> collateralTaxonomy = new ArrayList<CollateralTaxonomy.CollateralTaxonomyBuilder>();
        protected Boolean domesticCurrencyIssued;
        protected ListingType.ListingTypeBuilder listing;

        @Override
        @RosettaAttribute(value="collateralAssetType")
        @RuneAttribute(value="collateralAssetType")
        public List<? extends AssetType.AssetTypeBuilder> getCollateralAssetType() {
            return this.collateralAssetType;
        }

        @Override
        public AssetType.AssetTypeBuilder getOrCreateCollateralAssetType(int index) {
            if (this.collateralAssetType == null) {
                this.collateralAssetType = new ArrayList<AssetType.AssetTypeBuilder>();
            }
            return (AssetType.AssetTypeBuilder)this.getIndex(this.collateralAssetType, index, () -> {
                AssetType.AssetTypeBuilder newCollateralAssetType = AssetType.builder();
                return newCollateralAssetType;
            });
        }

        @Override
        @RosettaAttribute(value="assetCountryOfOrigin")
        @RuneAttribute(value="assetCountryOfOrigin")
        public List<ISOCountryCodeEnum> getAssetCountryOfOrigin() {
            return this.assetCountryOfOrigin;
        }

        @Override
        @RosettaAttribute(value="denominatedCurrency")
        @RuneAttribute(value="denominatedCurrency")
        public List<CurrencyCodeEnum> getDenominatedCurrency() {
            return this.denominatedCurrency;
        }

        @Override
        @RosettaAttribute(value="agencyRating")
        @RuneAttribute(value="agencyRating")
        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getAgencyRating() {
            return this.agencyRating;
        }

        @Override
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateAgencyRating(int index) {
            if (this.agencyRating == null) {
                this.agencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
            }
            return (AgencyRatingCriteria.AgencyRatingCriteriaBuilder)this.getIndex(this.agencyRating, index, () -> {
                AgencyRatingCriteria.AgencyRatingCriteriaBuilder newAgencyRating = AgencyRatingCriteria.builder();
                return newAgencyRating;
            });
        }

        @Override
        @RosettaAttribute(value="maturityType")
        @RuneAttribute(value="maturityType")
        public MaturityTypeEnum getMaturityType() {
            return this.maturityType;
        }

        @Override
        @RosettaAttribute(value="maturityRange")
        @RuneAttribute(value="maturityRange")
        public PeriodRange.PeriodRangeBuilder getMaturityRange() {
            return this.maturityRange;
        }

        @Override
        public PeriodRange.PeriodRangeBuilder getOrCreateMaturityRange() {
            PeriodRange.PeriodRangeBuilder result = this.maturityRange != null ? this.maturityRange : (this.maturityRange = PeriodRange.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        public List<? extends ProductIdentifier.ProductIdentifierBuilder> getProductIdentifier() {
            return this.productIdentifier;
        }

        @Override
        public ProductIdentifier.ProductIdentifierBuilder getOrCreateProductIdentifier(int index) {
            if (this.productIdentifier == null) {
                this.productIdentifier = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
            }
            return (ProductIdentifier.ProductIdentifierBuilder)this.getIndex(this.productIdentifier, index, () -> {
                ProductIdentifier.ProductIdentifierBuilder newProductIdentifier = ProductIdentifier.builder();
                return newProductIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="collateralTaxonomy")
        @RuneAttribute(value="collateralTaxonomy")
        public List<? extends CollateralTaxonomy.CollateralTaxonomyBuilder> getCollateralTaxonomy() {
            return this.collateralTaxonomy;
        }

        @Override
        public CollateralTaxonomy.CollateralTaxonomyBuilder getOrCreateCollateralTaxonomy(int index) {
            if (this.collateralTaxonomy == null) {
                this.collateralTaxonomy = new ArrayList<CollateralTaxonomy.CollateralTaxonomyBuilder>();
            }
            return (CollateralTaxonomy.CollateralTaxonomyBuilder)this.getIndex(this.collateralTaxonomy, index, () -> {
                CollateralTaxonomy.CollateralTaxonomyBuilder newCollateralTaxonomy = CollateralTaxonomy.builder();
                return newCollateralTaxonomy;
            });
        }

        @Override
        @RosettaAttribute(value="domesticCurrencyIssued")
        @RuneAttribute(value="domesticCurrencyIssued")
        public Boolean getDomesticCurrencyIssued() {
            return this.domesticCurrencyIssued;
        }

        @Override
        @RosettaAttribute(value="listing")
        @RuneAttribute(value="listing")
        public ListingType.ListingTypeBuilder getListing() {
            return this.listing;
        }

        @Override
        public ListingType.ListingTypeBuilder getOrCreateListing() {
            ListingType.ListingTypeBuilder result = this.listing != null ? this.listing : (this.listing = ListingType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralAssetType")
        @RuneAttribute(value="collateralAssetType")
        public AssetCriteriaBuilder addCollateralAssetType(AssetType _collateralAssetType) {
            if (_collateralAssetType != null) {
                this.collateralAssetType.add(_collateralAssetType.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralAssetType(AssetType _collateralAssetType, int idx) {
            this.getIndex(this.collateralAssetType, idx, () -> _collateralAssetType.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralAssetType(List<? extends AssetType> collateralAssetTypes) {
            if (collateralAssetTypes != null) {
                for (AssetType assetType : collateralAssetTypes) {
                    this.collateralAssetType.add(assetType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralAssetType")
        public AssetCriteriaBuilder setCollateralAssetType(List<? extends AssetType> collateralAssetTypes) {
            this.collateralAssetType = collateralAssetTypes == null ? new ArrayList<AssetType.AssetTypeBuilder>() : (List)collateralAssetTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="assetCountryOfOrigin")
        @RuneAttribute(value="assetCountryOfOrigin")
        public AssetCriteriaBuilder addAssetCountryOfOrigin(ISOCountryCodeEnum _assetCountryOfOrigin) {
            if (_assetCountryOfOrigin != null) {
                this.assetCountryOfOrigin.add(_assetCountryOfOrigin);
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAssetCountryOfOrigin(ISOCountryCodeEnum _assetCountryOfOrigin, int idx) {
            this.getIndex(this.assetCountryOfOrigin, idx, () -> _assetCountryOfOrigin);
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAssetCountryOfOrigin(List<ISOCountryCodeEnum> assetCountryOfOrigins) {
            if (assetCountryOfOrigins != null) {
                for (ISOCountryCodeEnum toAdd : assetCountryOfOrigins) {
                    this.assetCountryOfOrigin.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="assetCountryOfOrigin")
        public AssetCriteriaBuilder setAssetCountryOfOrigin(List<ISOCountryCodeEnum> assetCountryOfOrigins) {
            this.assetCountryOfOrigin = assetCountryOfOrigins == null ? new ArrayList<ISOCountryCodeEnum>() : (List)assetCountryOfOrigins.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="denominatedCurrency")
        @RuneAttribute(value="denominatedCurrency")
        public AssetCriteriaBuilder addDenominatedCurrency(CurrencyCodeEnum _denominatedCurrency) {
            if (_denominatedCurrency != null) {
                this.denominatedCurrency.add(_denominatedCurrency);
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addDenominatedCurrency(CurrencyCodeEnum _denominatedCurrency, int idx) {
            this.getIndex(this.denominatedCurrency, idx, () -> _denominatedCurrency);
            return this;
        }

        @Override
        public AssetCriteriaBuilder addDenominatedCurrency(List<CurrencyCodeEnum> denominatedCurrencys) {
            if (denominatedCurrencys != null) {
                for (CurrencyCodeEnum toAdd : denominatedCurrencys) {
                    this.denominatedCurrency.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="denominatedCurrency")
        public AssetCriteriaBuilder setDenominatedCurrency(List<CurrencyCodeEnum> denominatedCurrencys) {
            this.denominatedCurrency = denominatedCurrencys == null ? new ArrayList<CurrencyCodeEnum>() : (List)denominatedCurrencys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="agencyRating")
        @RuneAttribute(value="agencyRating")
        public AssetCriteriaBuilder addAgencyRating(AgencyRatingCriteria _agencyRating) {
            if (_agencyRating != null) {
                this.agencyRating.add(_agencyRating.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAgencyRating(AgencyRatingCriteria _agencyRating, int idx) {
            this.getIndex(this.agencyRating, idx, () -> _agencyRating.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAgencyRating(List<? extends AgencyRatingCriteria> agencyRatings) {
            if (agencyRatings != null) {
                for (AgencyRatingCriteria agencyRatingCriteria : agencyRatings) {
                    this.agencyRating.add(agencyRatingCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="agencyRating")
        public AssetCriteriaBuilder setAgencyRating(List<? extends AgencyRatingCriteria> agencyRatings) {
            this.agencyRating = agencyRatings == null ? new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>() : (List)agencyRatings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityType")
        @RuneAttribute(value="maturityType")
        public AssetCriteriaBuilder setMaturityType(MaturityTypeEnum _maturityType) {
            this.maturityType = _maturityType == null ? null : _maturityType;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityRange")
        @RuneAttribute(value="maturityRange")
        public AssetCriteriaBuilder setMaturityRange(PeriodRange _maturityRange) {
            this.maturityRange = _maturityRange == null ? null : _maturityRange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        public AssetCriteriaBuilder addProductIdentifier(ProductIdentifier _productIdentifier) {
            if (_productIdentifier != null) {
                this.productIdentifier.add(_productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addProductIdentifier(ProductIdentifier _productIdentifier, int idx) {
            this.getIndex(this.productIdentifier, idx, () -> _productIdentifier.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addProductIdentifier(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.productIdentifier.add(productIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productIdentifier")
        public AssetCriteriaBuilder setProductIdentifier(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList<ProductIdentifier.ProductIdentifierBuilder>() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTaxonomy")
        @RuneAttribute(value="collateralTaxonomy")
        public AssetCriteriaBuilder addCollateralTaxonomy(CollateralTaxonomy _collateralTaxonomy) {
            if (_collateralTaxonomy != null) {
                this.collateralTaxonomy.add(_collateralTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralTaxonomy(CollateralTaxonomy _collateralTaxonomy, int idx) {
            this.getIndex(this.collateralTaxonomy, idx, () -> _collateralTaxonomy.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralTaxonomy(List<? extends CollateralTaxonomy> collateralTaxonomys) {
            if (collateralTaxonomys != null) {
                for (CollateralTaxonomy collateralTaxonomy : collateralTaxonomys) {
                    this.collateralTaxonomy.add(collateralTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralTaxonomy")
        public AssetCriteriaBuilder setCollateralTaxonomy(List<? extends CollateralTaxonomy> collateralTaxonomys) {
            this.collateralTaxonomy = collateralTaxonomys == null ? new ArrayList<CollateralTaxonomy.CollateralTaxonomyBuilder>() : (List)collateralTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="domesticCurrencyIssued")
        @RuneAttribute(value="domesticCurrencyIssued")
        public AssetCriteriaBuilder setDomesticCurrencyIssued(Boolean _domesticCurrencyIssued) {
            this.domesticCurrencyIssued = _domesticCurrencyIssued == null ? null : _domesticCurrencyIssued;
            return this;
        }

        @Override
        @RosettaAttribute(value="listing")
        @RuneAttribute(value="listing")
        public AssetCriteriaBuilder setListing(ListingType _listing) {
            this.listing = _listing == null ? null : _listing.toBuilder();
            return this;
        }

        @Override
        public AssetCriteria build() {
            return new AssetCriteriaImpl(this);
        }

        @Override
        public AssetCriteriaBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetCriteriaBuilder prune() {
            this.collateralAssetType = this.collateralAssetType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.agencyRating = this.agencyRating.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.maturityRange != null && !this.maturityRange.prune().hasData()) {
                this.maturityRange = null;
            }
            this.productIdentifier = this.productIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.collateralTaxonomy = this.collateralTaxonomy.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.listing != null && !this.listing.prune().hasData()) {
                this.listing = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCollateralAssetType() != null && this.getCollateralAssetType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAssetCountryOfOrigin() != null && !this.getAssetCountryOfOrigin().isEmpty()) {
                return true;
            }
            if (this.getDenominatedCurrency() != null && !this.getDenominatedCurrency().isEmpty()) {
                return true;
            }
            if (this.getAgencyRating() != null && this.getAgencyRating().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getMaturityType() != null) {
                return true;
            }
            if (this.getMaturityRange() != null && this.getMaturityRange().hasData()) {
                return true;
            }
            if (this.getProductIdentifier() != null && this.getProductIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateralTaxonomy() != null && this.getCollateralTaxonomy().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDomesticCurrencyIssued() != null) {
                return true;
            }
            return this.getListing() != null && this.getListing().hasData();
        }

        public AssetCriteriaBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetCriteriaBuilder o = (AssetCriteriaBuilder)other;
            merger.mergeRosetta(this.getCollateralAssetType(), o.getCollateralAssetType(), this::getOrCreateCollateralAssetType);
            merger.mergeRosetta(this.getAgencyRating(), o.getAgencyRating(), this::getOrCreateAgencyRating);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMaturityRange(), (RosettaModelObjectBuilder)o.getMaturityRange(), this::setMaturityRange);
            merger.mergeRosetta(this.getProductIdentifier(), o.getProductIdentifier(), this::getOrCreateProductIdentifier);
            merger.mergeRosetta(this.getCollateralTaxonomy(), o.getCollateralTaxonomy(), this::getOrCreateCollateralTaxonomy);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getListing(), (RosettaModelObjectBuilder)o.getListing(), this::setListing);
            merger.mergeBasic(this.getAssetCountryOfOrigin(), o.getAssetCountryOfOrigin(), this::addAssetCountryOfOrigin);
            merger.mergeBasic(this.getDenominatedCurrency(), o.getDenominatedCurrency(), this::addDenominatedCurrency);
            merger.mergeBasic((Object)this.getMaturityType(), (Object)o.getMaturityType(), this::setMaturityType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDomesticCurrencyIssued(), (Object)o.getDomesticCurrencyIssued(), this::setDomesticCurrencyIssued, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetCriteria _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.collateralAssetType, _that.getCollateralAssetType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assetCountryOfOrigin, _that.getAssetCountryOfOrigin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.denominatedCurrency, _that.getDenominatedCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.agencyRating, _that.getAgencyRating())) {
                return false;
            }
            if (!Objects.equals((Object)this.maturityType, (Object)_that.getMaturityType())) {
                return false;
            }
            if (!Objects.equals(this.maturityRange, _that.getMaturityRange())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productIdentifier, _that.getProductIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralTaxonomy, _that.getCollateralTaxonomy())) {
                return false;
            }
            if (!Objects.equals(this.domesticCurrencyIssued, _that.getDomesticCurrencyIssued())) {
                return false;
            }
            return Objects.equals(this.listing, _that.getListing());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralAssetType != null ? this.collateralAssetType.hashCode() : 0);
            _result = 31 * _result + (this.assetCountryOfOrigin != null ? this.assetCountryOfOrigin.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.denominatedCurrency != null ? this.denominatedCurrency.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.agencyRating != null ? this.agencyRating.hashCode() : 0);
            _result = 31 * _result + (this.maturityType != null ? ((Object)((Object)this.maturityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.maturityRange != null ? this.maturityRange.hashCode() : 0);
            _result = 31 * _result + (this.productIdentifier != null ? this.productIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.collateralTaxonomy != null ? this.collateralTaxonomy.hashCode() : 0);
            _result = 31 * _result + (this.domesticCurrencyIssued != null ? this.domesticCurrencyIssued.hashCode() : 0);
            _result = 31 * _result + (this.listing != null ? this.listing.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetCriteriaBuilder {collateralAssetType=" + this.collateralAssetType + ", assetCountryOfOrigin=" + this.assetCountryOfOrigin + ", denominatedCurrency=" + this.denominatedCurrency + ", agencyRating=" + this.agencyRating + ", maturityType=" + (Object)((Object)this.maturityType) + ", maturityRange=" + this.maturityRange + ", productIdentifier=" + this.productIdentifier + ", collateralTaxonomy=" + this.collateralTaxonomy + ", domesticCurrencyIssued=" + this.domesticCurrencyIssued + ", listing=" + this.listing + '}';
        }
    }

    public static interface AssetCriteriaBuilder
    extends AssetCriteria,
    RosettaModelObjectBuilder {
        public AssetType.AssetTypeBuilder getOrCreateCollateralAssetType(int var1);

        public List<? extends AssetType.AssetTypeBuilder> getCollateralAssetType();

        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateAgencyRating(int var1);

        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getAgencyRating();

        public PeriodRange.PeriodRangeBuilder getOrCreateMaturityRange();

        @Override
        public PeriodRange.PeriodRangeBuilder getMaturityRange();

        public ProductIdentifier.ProductIdentifierBuilder getOrCreateProductIdentifier(int var1);

        public List<? extends ProductIdentifier.ProductIdentifierBuilder> getProductIdentifier();

        public CollateralTaxonomy.CollateralTaxonomyBuilder getOrCreateCollateralTaxonomy(int var1);

        public List<? extends CollateralTaxonomy.CollateralTaxonomyBuilder> getCollateralTaxonomy();

        public ListingType.ListingTypeBuilder getOrCreateListing();

        @Override
        public ListingType.ListingTypeBuilder getListing();

        public AssetCriteriaBuilder addCollateralAssetType(AssetType var1);

        public AssetCriteriaBuilder addCollateralAssetType(AssetType var1, int var2);

        public AssetCriteriaBuilder addCollateralAssetType(List<? extends AssetType> var1);

        public AssetCriteriaBuilder setCollateralAssetType(List<? extends AssetType> var1);

        public AssetCriteriaBuilder addAssetCountryOfOrigin(ISOCountryCodeEnum var1);

        public AssetCriteriaBuilder addAssetCountryOfOrigin(ISOCountryCodeEnum var1, int var2);

        public AssetCriteriaBuilder addAssetCountryOfOrigin(List<ISOCountryCodeEnum> var1);

        public AssetCriteriaBuilder setAssetCountryOfOrigin(List<ISOCountryCodeEnum> var1);

        public AssetCriteriaBuilder addDenominatedCurrency(CurrencyCodeEnum var1);

        public AssetCriteriaBuilder addDenominatedCurrency(CurrencyCodeEnum var1, int var2);

        public AssetCriteriaBuilder addDenominatedCurrency(List<CurrencyCodeEnum> var1);

        public AssetCriteriaBuilder setDenominatedCurrency(List<CurrencyCodeEnum> var1);

        public AssetCriteriaBuilder addAgencyRating(AgencyRatingCriteria var1);

        public AssetCriteriaBuilder addAgencyRating(AgencyRatingCriteria var1, int var2);

        public AssetCriteriaBuilder addAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public AssetCriteriaBuilder setAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public AssetCriteriaBuilder setMaturityType(MaturityTypeEnum var1);

        public AssetCriteriaBuilder setMaturityRange(PeriodRange var1);

        public AssetCriteriaBuilder addProductIdentifier(ProductIdentifier var1);

        public AssetCriteriaBuilder addProductIdentifier(ProductIdentifier var1, int var2);

        public AssetCriteriaBuilder addProductIdentifier(List<? extends ProductIdentifier> var1);

        public AssetCriteriaBuilder setProductIdentifier(List<? extends ProductIdentifier> var1);

        public AssetCriteriaBuilder addCollateralTaxonomy(CollateralTaxonomy var1);

        public AssetCriteriaBuilder addCollateralTaxonomy(CollateralTaxonomy var1, int var2);

        public AssetCriteriaBuilder addCollateralTaxonomy(List<? extends CollateralTaxonomy> var1);

        public AssetCriteriaBuilder setCollateralTaxonomy(List<? extends CollateralTaxonomy> var1);

        public AssetCriteriaBuilder setDomesticCurrencyIssued(Boolean var1);

        public AssetCriteriaBuilder setListing(ListingType var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("collateralAssetType"), processor, AssetType.AssetTypeBuilder.class, this.getCollateralAssetType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetCountryOfOrigin"), ISOCountryCodeEnum.class, this.getAssetCountryOfOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("denominatedCurrency"), CurrencyCodeEnum.class, this.getDenominatedCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agencyRating"), processor, AgencyRatingCriteria.AgencyRatingCriteriaBuilder.class, this.getAgencyRating(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityType"), MaturityTypeEnum.class, (Object)this.getMaturityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("maturityRange"), processor, PeriodRange.PeriodRangeBuilder.class, this.getMaturityRange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productIdentifier"), processor, ProductIdentifier.ProductIdentifierBuilder.class, this.getProductIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralTaxonomy"), processor, CollateralTaxonomy.CollateralTaxonomyBuilder.class, this.getCollateralTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("domesticCurrencyIssued"), Boolean.class, (Object)this.getDomesticCurrencyIssued(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("listing"), processor, ListingType.ListingTypeBuilder.class, this.getListing(), new AttributeMeta[0]);
        }

        public AssetCriteriaBuilder prune();
    }

    public static class AssetCriteriaImpl
    implements AssetCriteria {
        private final List<? extends AssetType> collateralAssetType;
        private final List<ISOCountryCodeEnum> assetCountryOfOrigin;
        private final List<CurrencyCodeEnum> denominatedCurrency;
        private final List<? extends AgencyRatingCriteria> agencyRating;
        private final MaturityTypeEnum maturityType;
        private final PeriodRange maturityRange;
        private final List<? extends ProductIdentifier> productIdentifier;
        private final List<? extends CollateralTaxonomy> collateralTaxonomy;
        private final Boolean domesticCurrencyIssued;
        private final ListingType listing;

        protected AssetCriteriaImpl(AssetCriteriaBuilder builder) {
            this.collateralAssetType = Optional.ofNullable(builder.getCollateralAssetType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.assetCountryOfOrigin = Optional.ofNullable(builder.getAssetCountryOfOrigin()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.denominatedCurrency = Optional.ofNullable(builder.getDenominatedCurrency()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.agencyRating = Optional.ofNullable(builder.getAgencyRating()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.maturityType = builder.getMaturityType();
            this.maturityRange = Optional.ofNullable(builder.getMaturityRange()).map(f -> f.build()).orElse(null);
            this.productIdentifier = Optional.ofNullable(builder.getProductIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralTaxonomy = Optional.ofNullable(builder.getCollateralTaxonomy()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.domesticCurrencyIssued = builder.getDomesticCurrencyIssued();
            this.listing = Optional.ofNullable(builder.getListing()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="collateralAssetType")
        @RuneAttribute(value="collateralAssetType")
        public List<? extends AssetType> getCollateralAssetType() {
            return this.collateralAssetType;
        }

        @Override
        @RosettaAttribute(value="assetCountryOfOrigin")
        @RuneAttribute(value="assetCountryOfOrigin")
        public List<ISOCountryCodeEnum> getAssetCountryOfOrigin() {
            return this.assetCountryOfOrigin;
        }

        @Override
        @RosettaAttribute(value="denominatedCurrency")
        @RuneAttribute(value="denominatedCurrency")
        public List<CurrencyCodeEnum> getDenominatedCurrency() {
            return this.denominatedCurrency;
        }

        @Override
        @RosettaAttribute(value="agencyRating")
        @RuneAttribute(value="agencyRating")
        public List<? extends AgencyRatingCriteria> getAgencyRating() {
            return this.agencyRating;
        }

        @Override
        @RosettaAttribute(value="maturityType")
        @RuneAttribute(value="maturityType")
        public MaturityTypeEnum getMaturityType() {
            return this.maturityType;
        }

        @Override
        @RosettaAttribute(value="maturityRange")
        @RuneAttribute(value="maturityRange")
        public PeriodRange getMaturityRange() {
            return this.maturityRange;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        public List<? extends ProductIdentifier> getProductIdentifier() {
            return this.productIdentifier;
        }

        @Override
        @RosettaAttribute(value="collateralTaxonomy")
        @RuneAttribute(value="collateralTaxonomy")
        public List<? extends CollateralTaxonomy> getCollateralTaxonomy() {
            return this.collateralTaxonomy;
        }

        @Override
        @RosettaAttribute(value="domesticCurrencyIssued")
        @RuneAttribute(value="domesticCurrencyIssued")
        public Boolean getDomesticCurrencyIssued() {
            return this.domesticCurrencyIssued;
        }

        @Override
        @RosettaAttribute(value="listing")
        @RuneAttribute(value="listing")
        public ListingType getListing() {
            return this.listing;
        }

        @Override
        public AssetCriteria build() {
            return this;
        }

        @Override
        public AssetCriteriaBuilder toBuilder() {
            AssetCriteriaBuilder builder = AssetCriteria.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetCriteriaBuilder builder) {
            Optional.ofNullable(this.getCollateralAssetType()).ifPresent(builder::setCollateralAssetType);
            Optional.ofNullable(this.getAssetCountryOfOrigin()).ifPresent(builder::setAssetCountryOfOrigin);
            Optional.ofNullable(this.getDenominatedCurrency()).ifPresent(builder::setDenominatedCurrency);
            Optional.ofNullable(this.getAgencyRating()).ifPresent(builder::setAgencyRating);
            Optional.ofNullable(this.getMaturityType()).ifPresent(builder::setMaturityType);
            Optional.ofNullable(this.getMaturityRange()).ifPresent(builder::setMaturityRange);
            Optional.ofNullable(this.getProductIdentifier()).ifPresent(builder::setProductIdentifier);
            Optional.ofNullable(this.getCollateralTaxonomy()).ifPresent(builder::setCollateralTaxonomy);
            Optional.ofNullable(this.getDomesticCurrencyIssued()).ifPresent(builder::setDomesticCurrencyIssued);
            Optional.ofNullable(this.getListing()).ifPresent(builder::setListing);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetCriteria _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.collateralAssetType, _that.getCollateralAssetType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assetCountryOfOrigin, _that.getAssetCountryOfOrigin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.denominatedCurrency, _that.getDenominatedCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.agencyRating, _that.getAgencyRating())) {
                return false;
            }
            if (!Objects.equals((Object)this.maturityType, (Object)_that.getMaturityType())) {
                return false;
            }
            if (!Objects.equals(this.maturityRange, _that.getMaturityRange())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productIdentifier, _that.getProductIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralTaxonomy, _that.getCollateralTaxonomy())) {
                return false;
            }
            if (!Objects.equals(this.domesticCurrencyIssued, _that.getDomesticCurrencyIssued())) {
                return false;
            }
            return Objects.equals(this.listing, _that.getListing());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralAssetType != null ? this.collateralAssetType.hashCode() : 0);
            _result = 31 * _result + (this.assetCountryOfOrigin != null ? this.assetCountryOfOrigin.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.denominatedCurrency != null ? this.denominatedCurrency.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.agencyRating != null ? this.agencyRating.hashCode() : 0);
            _result = 31 * _result + (this.maturityType != null ? ((Object)((Object)this.maturityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.maturityRange != null ? this.maturityRange.hashCode() : 0);
            _result = 31 * _result + (this.productIdentifier != null ? this.productIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.collateralTaxonomy != null ? this.collateralTaxonomy.hashCode() : 0);
            _result = 31 * _result + (this.domesticCurrencyIssued != null ? this.domesticCurrencyIssued.hashCode() : 0);
            _result = 31 * _result + (this.listing != null ? this.listing.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetCriteria {collateralAssetType=" + this.collateralAssetType + ", assetCountryOfOrigin=" + this.assetCountryOfOrigin + ", denominatedCurrency=" + this.denominatedCurrency + ", agencyRating=" + this.agencyRating + ", maturityType=" + (Object)((Object)this.maturityType) + ", maturityRange=" + this.maturityRange + ", productIdentifier=" + this.productIdentifier + ", collateralTaxonomy=" + this.collateralTaxonomy + ", domesticCurrencyIssued=" + this.domesticCurrencyIssued + ", listing=" + this.listing + '}';
        }
    }
}

