/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.IndexTransitionInstruction;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="IndexTransitionInstructionPriceQuantity")
@ImplementedBy(value=Default.class)
public interface IndexTransitionInstructionPriceQuantity
extends Validator<IndexTransitionInstruction> {
    public static final String NAME = "IndexTransitionInstructionPriceQuantity";
    public static final String DEFINITION = "priceQuantity -> price -> priceType contains PriceTypeEnum -> InterestRate and priceQuantity -> observable -> rateOption exists and priceQuantity -> quantity is absent";

    public static class NoOp
    implements IndexTransitionInstructionPriceQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, IndexTransitionInstruction indexTransitionInstruction) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements IndexTransitionInstructionPriceQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, IndexTransitionInstruction indexTransitionInstruction) {
            ComparisonResult result = this.executeDataRule(indexTransitionInstruction);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)IndexTransitionInstructionPriceQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"IndexTransitionInstruction", (RosettaPath)path, (String)IndexTransitionInstructionPriceQuantity.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)IndexTransitionInstructionPriceQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"IndexTransitionInstruction", (RosettaPath)path, (String)IndexTransitionInstructionPriceQuantity.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(IndexTransitionInstruction indexTransitionInstruction) {
            try {
                return ExpressionOperators.contains((Mapper)MapperS.of((Object)indexTransitionInstruction).mapC("getPriceQuantity", _indexTransitionInstruction -> _indexTransitionInstruction.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)indexTransitionInstruction).mapC("getPriceQuantity", _indexTransitionInstruction -> _indexTransitionInstruction.getPriceQuantity()).map("getObservable", priceQuantity -> priceQuantity.getObservable()).map("getRateOption", observable -> observable.getRateOption()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)indexTransitionInstruction).mapC("getPriceQuantity", _indexTransitionInstruction -> _indexTransitionInstruction.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

