# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['WeightedAveragingObservation']


class WeightedAveragingObservation(BaseDataClass):
  """
  A single weighted averaging observation.
  """
  dateTime: Optional[datetime] = Field(None, description="Observation date time, which should be used when literal observation dates are required. The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.")
  """
  Observation date time, which should be used when literal observation dates are required. The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.
  """
  observationNumber: Optional[int] = Field(None, description="Observation number, which should be unique, within a series generated by a date schedule.")
  """
  Observation number, which should be unique, within a series generated by a date schedule.
  """
  weight: Decimal = Field(..., description="Observation weight, which is used as a multiplier for the observation value.")
  """
  Observation weight, which is used as a multiplier for the observation value.
  """
  
  @rosetta_condition
  def condition_0_WeightedAveragingObservationChoice(self):
    """
     Choice rule to represent an FpML choice construct between date times for literal date values, and observation numbers for schedule generated observations.
    """
    return self.check_one_of_constraint('dateTime', 'observationNumber', necessity=True)
  
  @rosetta_condition
  def condition_1_PositiveObservationNumber(self):
    """
     FpML specifies observationNumber as a positive integer.
    """
    def _then_fn0():
      return all_elements(_resolve_rosetta_attr(self, "observationNumber"), ">=", 0)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "observationNumber")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_2_PositiveWeight(self):
    """
     FpML specifies observationNumber as a non-negative decimal.
    """
    return all_elements(_resolve_rosetta_attr(self, "weight"), ">=", 0.0)


WeightedAveragingObservation.update_forward_refs()
