# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['EquitySwapMasterConfirmation2018']

from cdm.legaldocumentation.master.EquityMasterConfirmation import EquityMasterConfirmation

class EquitySwapMasterConfirmation2018(EquityMasterConfirmation):
  """
  Specification for the General Terms and Relationship Supplement Elections as provided in the 2018 ISDA CDM Equity Confirmation for Security Equity Swap.
  """
  typeOfSwapElection: ReturnTypeEnum = Field(..., description="Per Part 1 Section 4, 'Dividend Obligations', of the 2018 ISDA CDM Equity Confirmation, Para 4.2 'Dividend Returns'")
  """
  Per Part 1 Section 4, 'Dividend Obligations', of the 2018 ISDA CDM Equity Confirmation, Para 4.2 'Dividend Returns'
  """
  pricingMethodElection: PriceReturnTerms = Field(..., description="Per Part 1 Section 5, 'Pricing', of the 2018 ISDA CDM Equity Confirmation, Para 5.1")
  """
  Per Part 1 Section 5, 'Pricing', of the 2018 ISDA CDM Equity Confirmation, Para 5.1
  """
  linearInterpolationElection: InterpolationMethodEnum = Field(..., description="Per Part 1 Section 3, 'Floating Obligations', of the 2018 ISDA CDM Equity Confirmation. Para 3.3")
  """
  Per Part 1 Section 3, 'Floating Obligations', of the 2018 ISDA CDM Equity Confirmation. Para 3.3
  """
  settlementTerms: SettlementTerms = Field(..., description="Per Part 1 Section 8, 'Settlement', of the 2018 ISDA CDM Equity Confirmation for Security Equity Swap")
  """
  Per Part 1 Section 8, 'Settlement', of the 2018 ISDA CDM Equity Confirmation for Security Equity Swap
  """
  valuationDates: ValuationDates = Field(..., description="The parameters used to generate the 'Equity Valuation Dates' schedule, including the Effective Date and Termination Date for the Swap.")
  """
  The parameters used to generate the 'Equity Valuation Dates' schedule, including the Effective Date and Termination Date for the Swap.
  """
  equityCashSettlementDates: PaymentDates = Field(..., description="The parameters used to generate the payment date schedule, relative to the equityCalculationPeriod. Per Part 1 Section 12, 'Definitions', of the 2018 ISDA CDM Equity Confirmation. Para 73")
  """
  The parameters used to generate the payment date schedule, relative to the equityCalculationPeriod. Per Part 1 Section 12, 'Definitions', of the 2018 ISDA CDM Equity Confirmation. Para 73
  """

from cdm.product.asset.ReturnTypeEnum import ReturnTypeEnum
from cdm.product.asset.PriceReturnTerms import PriceReturnTerms
from cdm.observable.asset.InterpolationMethodEnum import InterpolationMethodEnum
from cdm.product.common.settlement.SettlementTerms import SettlementTerms
from cdm.observable.asset.ValuationDates import ValuationDates
from cdm.product.common.schedule.PaymentDates import PaymentDates

EquitySwapMasterConfirmation2018.update_forward_refs()
