/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="EconomicTermsFpML_cd_27")
@ImplementedBy(value=Default.class)
public interface EconomicTermsFpMLCd27
extends Validator<EconomicTerms> {
    public static final String NAME = "EconomicTermsFpML_cd_27";
    public static final String DEFINITION = "if payout -> creditDefaultPayout exists and payout -> cashflow exists and terminationDate exists and payout -> cashflow -> settlementTerms -> settlementDate -> adjustableOrRelativeDate exists then payout -> cashflow -> settlementTerms -> settlementDate -> adjustableOrRelativeDate -> unadjustedDate all < terminationDate -> adjustableDate -> unadjustedDate or payout -> cashflow -> settlementTerms -> settlementDate -> adjustableOrRelativeDate -> adjustedDate all < terminationDate -> adjustableDate -> adjustedDate or payout -> cashflow -> settlementTerms -> settlementDate -> adjustableOrRelativeDate -> relativeDate -> adjustedDate all < terminationDate -> adjustableDate -> adjustedDate";

    public ValidationResult<EconomicTerms> validate(RosettaPath var1, EconomicTerms var2);

    public static class NoOp
    implements EconomicTermsFpMLCd27 {
        @Override
        public ValidationResult<EconomicTerms> validate(RosettaPath path, EconomicTerms economicTerms) {
            return ValidationResult.success((String)EconomicTermsFpMLCd27.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsFpMLCd27.DEFINITION);
        }
    }

    public static class Default
    implements EconomicTermsFpMLCd27 {
        @Override
        public ValidationResult<EconomicTerms> validate(RosettaPath path, EconomicTerms economicTerms) {
            ComparisonResult result = this.executeDataRule(economicTerms);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)EconomicTermsFpMLCd27.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsFpMLCd27.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition EconomicTermsFpML_cd_27 failed.";
            }
            return ValidationResult.failure((String)EconomicTermsFpMLCd27.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsFpMLCd27.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(EconomicTerms economicTerms) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCashflow", payout -> payout.getCashflow()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getTerminationDate", _economicTerms -> _economicTerms.getTerminationDate()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCashflow", payout -> payout.getCashflow()).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).map("getSettlementDate", settlementBase -> settlementBase.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.lessThan((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCashflow", payout -> payout.getCashflow()).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).map("getSettlementDate", settlementBase -> settlementBase.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()).map("getUnadjustedDate", adjustableOrAdjustedOrRelativeDate -> adjustableOrAdjustedOrRelativeDate.getUnadjustedDate()), (Mapper)MapperS.of((Object)economicTerms).map("getTerminationDate", _economicTerms -> _economicTerms.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.lessThan((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCashflow", payout -> payout.getCashflow()).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).map("getSettlementDate", settlementBase -> settlementBase.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()).map("getAdjustedDate", adjustableOrAdjustedOrRelativeDate -> adjustableOrAdjustedOrRelativeDate.getAdjustedDate()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)economicTerms).map("getTerminationDate", _economicTerms -> _economicTerms.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).map("getAdjustedDate", adjustableDate -> adjustableDate.getAdjustedDate()).map("getValue", _f -> _f.getValue()), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.lessThan((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCashflow", payout -> payout.getCashflow()).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).map("getSettlementDate", settlementBase -> settlementBase.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()).map("getRelativeDate", adjustableOrAdjustedOrRelativeDate -> adjustableOrAdjustedOrRelativeDate.getRelativeDate()).map("getAdjustedDate", relativeDateOffset -> relativeDateOffset.getAdjustedDate()), (Mapper)MapperS.of((Object)economicTerms).map("getTerminationDate", _economicTerms -> _economicTerms.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).map("getAdjustedDate", adjustableDate -> adjustableDate.getAdjustedDate()).map("getValue", _f -> _f.getValue()), (CardinalityOperator)CardinalityOperator.All));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

