/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.settlement.FixedPrice;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.meta.FixedPricePayoutMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FixedPricePayout", builder=FixedPricePayoutBuilderImpl.class, version="5.0.0")
public interface FixedPricePayout
extends PayoutBase,
GlobalKey {
    public static final FixedPricePayoutMeta metaData = new FixedPricePayoutMeta();

    public PaymentDates getPaymentDates();

    public FixedPrice getFixedPrice();

    public CalculationSchedule getSchedule();

    public MetaFields getMeta();

    @Override
    public FixedPricePayout build();

    @Override
    public FixedPricePayoutBuilder toBuilder();

    public static FixedPricePayoutBuilder builder() {
        return new FixedPricePayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends FixedPricePayout> metaData() {
        return metaData;
    }

    default public Class<? extends FixedPricePayout> getType() {
        return FixedPricePayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayoutBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedPrice"), processor, FixedPrice.class, this.getFixedPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.class, this.getSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class FixedPricePayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements FixedPricePayoutBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected PaymentDates.PaymentDatesBuilder paymentDates;
        protected FixedPrice.FixedPriceBuilder fixedPrice;
        protected CalculationSchedule.CalculationScheduleBuilder schedule;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="paymentDates")
        public PaymentDates.PaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates() {
            PaymentDates.PaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = PaymentDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedPrice")
        public FixedPrice.FixedPriceBuilder getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public FixedPrice.FixedPriceBuilder getOrCreateFixedPrice() {
            FixedPrice.FixedPriceBuilder result = this.fixedPrice != null ? this.fixedPrice : (this.fixedPrice = FixedPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="schedule")
        public CalculationSchedule.CalculationScheduleBuilder getSchedule() {
            return this.schedule;
        }

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule() {
            CalculationSchedule.CalculationScheduleBuilder result = this.schedule != null ? this.schedule : (this.schedule = CalculationSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        public FixedPricePayoutBuilder setPaymentDates(PaymentDates paymentDates) {
            this.paymentDates = paymentDates == null ? null : paymentDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedPrice")
        public FixedPricePayoutBuilder setFixedPrice(FixedPrice fixedPrice) {
            this.fixedPrice = fixedPrice == null ? null : fixedPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="schedule")
        public FixedPricePayoutBuilder setSchedule(CalculationSchedule schedule) {
            this.schedule = schedule == null ? null : schedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        public FixedPricePayoutBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        public FixedPricePayoutBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        public FixedPricePayoutBuilder setPriceQuantity(ResolvablePriceQuantity priceQuantity) {
            this.priceQuantity = priceQuantity == null ? null : priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        public FixedPricePayoutBuilder setPrincipalPayment(PrincipalPayments principalPayment) {
            this.principalPayment = principalPayment == null ? null : principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        public FixedPricePayoutBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayout build() {
            return new FixedPricePayoutImpl(this);
        }

        @Override
        public FixedPricePayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public FixedPricePayoutBuilder prune() {
            super.prune();
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.fixedPrice != null && !this.fixedPrice.prune().hasData()) {
                this.fixedPrice = null;
            }
            if (this.schedule != null && !this.schedule.prune().hasData()) {
                this.schedule = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            if (this.getFixedPrice() != null && this.getFixedPrice().hasData()) {
                return true;
            }
            return this.getSchedule() != null && this.getSchedule().hasData();
        }

        @Override
        public FixedPricePayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FixedPricePayoutBuilder o = (FixedPricePayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedPrice(), (RosettaModelObjectBuilder)o.getFixedPrice(), this::setFixedPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSchedule(), (RosettaModelObjectBuilder)o.getSchedule(), this::setSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPricePayout _that = (FixedPricePayout)this.getType().cast(o);
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPricePayoutBuilder {paymentDates=" + this.paymentDates + ", fixedPrice=" + this.fixedPrice + ", schedule=" + this.schedule + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static class FixedPricePayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements FixedPricePayout {
        private final PaymentDates paymentDates;
        private final FixedPrice fixedPrice;
        private final CalculationSchedule schedule;
        private final MetaFields meta;

        protected FixedPricePayoutImpl(FixedPricePayoutBuilder builder) {
            super(builder);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.fixedPrice = Optional.ofNullable(builder.getFixedPrice()).map(f -> f.build()).orElse(null);
            this.schedule = Optional.ofNullable(builder.getSchedule()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        public PaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        @RosettaAttribute(value="fixedPrice")
        public FixedPrice getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        @RosettaAttribute(value="schedule")
        public CalculationSchedule getSchedule() {
            return this.schedule;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public FixedPricePayout build() {
            return this;
        }

        @Override
        public FixedPricePayoutBuilder toBuilder() {
            FixedPricePayoutBuilder builder = FixedPricePayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FixedPricePayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getFixedPrice()).ifPresent(builder::setFixedPrice);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPricePayout _that = (FixedPricePayout)this.getType().cast(o);
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPricePayout {paymentDates=" + this.paymentDates + ", fixedPrice=" + this.fixedPrice + ", schedule=" + this.schedule + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface FixedPricePayoutBuilder
    extends FixedPricePayout,
    PayoutBase.PayoutBaseBuilder,
    RosettaModelObjectBuilder {
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates();

        public FixedPrice.FixedPriceBuilder getOrCreateFixedPrice();

        @Override
        public FixedPrice.FixedPriceBuilder getFixedPrice();

        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule();

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getSchedule();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public FixedPricePayoutBuilder setPaymentDates(PaymentDates var1);

        public FixedPricePayoutBuilder setFixedPrice(FixedPrice var1);

        public FixedPricePayoutBuilder setSchedule(CalculationSchedule var1);

        public FixedPricePayoutBuilder setMeta(MetaFields var1);

        @Override
        public FixedPricePayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public FixedPricePayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public FixedPricePayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public FixedPricePayoutBuilder setSettlementTerms(SettlementTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayoutBase.PayoutBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.PaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedPrice"), processor, FixedPrice.FixedPriceBuilder.class, this.getFixedPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.CalculationScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public FixedPricePayoutBuilder prune();
    }
}

