/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.BusinessDayConventionEnum;
import cdm.base.datetime.DayTypeEnum;
import cdm.base.datetime.Offset;
import cdm.base.datetime.PeriodEnum;
import cdm.base.datetime.metafields.ReferenceWithMetaBusinessCenters;
import cdm.product.common.schedule.DateRelativeToCalculationPeriodDates;
import cdm.product.common.schedule.DateRelativeToPaymentDates;
import cdm.product.common.schedule.DateRelativeToValuationDates;
import cdm.product.common.settlement.meta.FxFixingDateMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxFixingDate", builder=FxFixingDateBuilderImpl.class, version="5.0.0")
public interface FxFixingDate
extends Offset {
    public static final FxFixingDateMeta metaData = new FxFixingDateMeta();

    public BusinessDayConventionEnum getBusinessDayConvention();

    public BusinessCenters getBusinessCenters();

    public ReferenceWithMetaBusinessCenters getBusinessCentersReference();

    public DateRelativeToPaymentDates getDateRelativeToPaymentDates();

    public DateRelativeToCalculationPeriodDates getDateRelativeToCalculationPeriodDates();

    public DateRelativeToValuationDates getDateRelativeToValuationDates();

    public AdjustableOrRelativeDate getFxFixingDate();

    @Override
    public FxFixingDate build();

    @Override
    public FxFixingDateBuilder toBuilder();

    public static FxFixingDateBuilder builder() {
        return new FxFixingDateBuilderImpl();
    }

    default public RosettaMetaData<? extends FxFixingDate> metaData() {
        return metaData;
    }

    default public Class<? extends FxFixingDate> getType() {
        return FxFixingDate.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        Offset.super.process(path, processor);
        processor.processBasic(path.newSubPath("businessDayConvention"), BusinessDayConventionEnum.class, (Object)this.getBusinessDayConvention(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.class, this.getBusinessCenters(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCentersReference"), processor, ReferenceWithMetaBusinessCenters.class, this.getBusinessCentersReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateRelativeToPaymentDates"), processor, DateRelativeToPaymentDates.class, this.getDateRelativeToPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateRelativeToCalculationPeriodDates"), processor, DateRelativeToCalculationPeriodDates.class, this.getDateRelativeToCalculationPeriodDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateRelativeToValuationDates"), processor, DateRelativeToValuationDates.class, this.getDateRelativeToValuationDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFixingDate"), processor, AdjustableOrRelativeDate.class, this.getFxFixingDate(), new AttributeMeta[0]);
    }

    public static class FxFixingDateBuilderImpl
    extends Offset.OffsetBuilderImpl
    implements FxFixingDateBuilder {
        protected BusinessDayConventionEnum businessDayConvention;
        protected BusinessCenters.BusinessCentersBuilder businessCenters;
        protected ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder businessCentersReference;
        protected DateRelativeToPaymentDates.DateRelativeToPaymentDatesBuilder dateRelativeToPaymentDates;
        protected DateRelativeToCalculationPeriodDates.DateRelativeToCalculationPeriodDatesBuilder dateRelativeToCalculationPeriodDates;
        protected DateRelativeToValuationDates.DateRelativeToValuationDatesBuilder dateRelativeToValuationDates;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder fxFixingDate;

        @Override
        @RosettaAttribute(value="businessDayConvention")
        public BusinessDayConventionEnum getBusinessDayConvention() {
            return this.businessDayConvention;
        }

        @Override
        @RosettaAttribute(value="businessCenters")
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters() {
            BusinessCenters.BusinessCentersBuilder result = this.businessCenters != null ? this.businessCenters : (this.businessCenters = BusinessCenters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="businessCentersReference")
        public ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder getBusinessCentersReference() {
            return this.businessCentersReference;
        }

        @Override
        public ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder getOrCreateBusinessCentersReference() {
            ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder result = this.businessCentersReference != null ? this.businessCentersReference : (this.businessCentersReference = ReferenceWithMetaBusinessCenters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dateRelativeToPaymentDates")
        public DateRelativeToPaymentDates.DateRelativeToPaymentDatesBuilder getDateRelativeToPaymentDates() {
            return this.dateRelativeToPaymentDates;
        }

        @Override
        public DateRelativeToPaymentDates.DateRelativeToPaymentDatesBuilder getOrCreateDateRelativeToPaymentDates() {
            DateRelativeToPaymentDates.DateRelativeToPaymentDatesBuilder result = this.dateRelativeToPaymentDates != null ? this.dateRelativeToPaymentDates : (this.dateRelativeToPaymentDates = DateRelativeToPaymentDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dateRelativeToCalculationPeriodDates")
        public DateRelativeToCalculationPeriodDates.DateRelativeToCalculationPeriodDatesBuilder getDateRelativeToCalculationPeriodDates() {
            return this.dateRelativeToCalculationPeriodDates;
        }

        @Override
        public DateRelativeToCalculationPeriodDates.DateRelativeToCalculationPeriodDatesBuilder getOrCreateDateRelativeToCalculationPeriodDates() {
            DateRelativeToCalculationPeriodDates.DateRelativeToCalculationPeriodDatesBuilder result = this.dateRelativeToCalculationPeriodDates != null ? this.dateRelativeToCalculationPeriodDates : (this.dateRelativeToCalculationPeriodDates = DateRelativeToCalculationPeriodDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dateRelativeToValuationDates")
        public DateRelativeToValuationDates.DateRelativeToValuationDatesBuilder getDateRelativeToValuationDates() {
            return this.dateRelativeToValuationDates;
        }

        @Override
        public DateRelativeToValuationDates.DateRelativeToValuationDatesBuilder getOrCreateDateRelativeToValuationDates() {
            DateRelativeToValuationDates.DateRelativeToValuationDatesBuilder result = this.dateRelativeToValuationDates != null ? this.dateRelativeToValuationDates : (this.dateRelativeToValuationDates = DateRelativeToValuationDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxFixingDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getFxFixingDate() {
            return this.fxFixingDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateFxFixingDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.fxFixingDate != null ? this.fxFixingDate : (this.fxFixingDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="businessDayConvention")
        public FxFixingDateBuilder setBusinessDayConvention(BusinessDayConventionEnum businessDayConvention) {
            this.businessDayConvention = businessDayConvention == null ? null : businessDayConvention;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCenters")
        public FxFixingDateBuilder setBusinessCenters(BusinessCenters businessCenters) {
            this.businessCenters = businessCenters == null ? null : businessCenters.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCentersReference")
        public FxFixingDateBuilder setBusinessCentersReference(ReferenceWithMetaBusinessCenters businessCentersReference) {
            this.businessCentersReference = businessCentersReference == null ? null : businessCentersReference.toBuilder();
            return this;
        }

        @Override
        public FxFixingDateBuilder setBusinessCentersReferenceValue(BusinessCenters businessCentersReference) {
            this.getOrCreateBusinessCentersReference().setValue(businessCentersReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="dateRelativeToPaymentDates")
        public FxFixingDateBuilder setDateRelativeToPaymentDates(DateRelativeToPaymentDates dateRelativeToPaymentDates) {
            this.dateRelativeToPaymentDates = dateRelativeToPaymentDates == null ? null : dateRelativeToPaymentDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dateRelativeToCalculationPeriodDates")
        public FxFixingDateBuilder setDateRelativeToCalculationPeriodDates(DateRelativeToCalculationPeriodDates dateRelativeToCalculationPeriodDates) {
            this.dateRelativeToCalculationPeriodDates = dateRelativeToCalculationPeriodDates == null ? null : dateRelativeToCalculationPeriodDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dateRelativeToValuationDates")
        public FxFixingDateBuilder setDateRelativeToValuationDates(DateRelativeToValuationDates dateRelativeToValuationDates) {
            this.dateRelativeToValuationDates = dateRelativeToValuationDates == null ? null : dateRelativeToValuationDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFixingDate")
        public FxFixingDateBuilder setFxFixingDate(AdjustableOrRelativeDate fxFixingDate) {
            this.fxFixingDate = fxFixingDate == null ? null : fxFixingDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayType")
        public FxFixingDateBuilder setDayType(DayTypeEnum dayType) {
            this.dayType = dayType == null ? null : dayType;
            return this;
        }

        @Override
        @RosettaAttribute(value="periodMultiplier")
        public FxFixingDateBuilder setPeriodMultiplier(Integer periodMultiplier) {
            this.periodMultiplier = periodMultiplier == null ? null : periodMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="period")
        public FxFixingDateBuilder setPeriod(PeriodEnum period) {
            this.period = period == null ? null : period;
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        public FxFixingDateBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public FxFixingDate build() {
            return new FxFixingDateImpl(this);
        }

        @Override
        public FxFixingDateBuilder toBuilder() {
            return this;
        }

        @Override
        public FxFixingDateBuilder prune() {
            super.prune();
            if (this.businessCenters != null && !this.businessCenters.prune().hasData()) {
                this.businessCenters = null;
            }
            if (this.businessCentersReference != null && !this.businessCentersReference.prune().hasData()) {
                this.businessCentersReference = null;
            }
            if (this.dateRelativeToPaymentDates != null && !this.dateRelativeToPaymentDates.prune().hasData()) {
                this.dateRelativeToPaymentDates = null;
            }
            if (this.dateRelativeToCalculationPeriodDates != null && !this.dateRelativeToCalculationPeriodDates.prune().hasData()) {
                this.dateRelativeToCalculationPeriodDates = null;
            }
            if (this.dateRelativeToValuationDates != null && !this.dateRelativeToValuationDates.prune().hasData()) {
                this.dateRelativeToValuationDates = null;
            }
            if (this.fxFixingDate != null && !this.fxFixingDate.prune().hasData()) {
                this.fxFixingDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBusinessDayConvention() != null) {
                return true;
            }
            if (this.getBusinessCenters() != null && this.getBusinessCenters().hasData()) {
                return true;
            }
            if (this.getBusinessCentersReference() != null && this.getBusinessCentersReference().hasData()) {
                return true;
            }
            if (this.getDateRelativeToPaymentDates() != null && this.getDateRelativeToPaymentDates().hasData()) {
                return true;
            }
            if (this.getDateRelativeToCalculationPeriodDates() != null && this.getDateRelativeToCalculationPeriodDates().hasData()) {
                return true;
            }
            if (this.getDateRelativeToValuationDates() != null && this.getDateRelativeToValuationDates().hasData()) {
                return true;
            }
            return this.getFxFixingDate() != null && this.getFxFixingDate().hasData();
        }

        @Override
        public FxFixingDateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxFixingDateBuilder o = (FxFixingDateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCenters(), (RosettaModelObjectBuilder)o.getBusinessCenters(), this::setBusinessCenters);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCentersReference(), (RosettaModelObjectBuilder)o.getBusinessCentersReference(), this::setBusinessCentersReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateRelativeToPaymentDates(), (RosettaModelObjectBuilder)o.getDateRelativeToPaymentDates(), this::setDateRelativeToPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateRelativeToCalculationPeriodDates(), (RosettaModelObjectBuilder)o.getDateRelativeToCalculationPeriodDates(), this::setDateRelativeToCalculationPeriodDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateRelativeToValuationDates(), (RosettaModelObjectBuilder)o.getDateRelativeToValuationDates(), this::setDateRelativeToValuationDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxFixingDate(), (RosettaModelObjectBuilder)o.getFxFixingDate(), this::setFxFixingDate);
            merger.mergeBasic((Object)this.getBusinessDayConvention(), (Object)o.getBusinessDayConvention(), this::setBusinessDayConvention, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxFixingDate _that = (FxFixingDate)this.getType().cast(o);
            if (!Objects.equals((Object)this.businessDayConvention, (Object)_that.getBusinessDayConvention())) {
                return false;
            }
            if (!Objects.equals(this.businessCenters, _that.getBusinessCenters())) {
                return false;
            }
            if (!Objects.equals(this.businessCentersReference, _that.getBusinessCentersReference())) {
                return false;
            }
            if (!Objects.equals(this.dateRelativeToPaymentDates, _that.getDateRelativeToPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.dateRelativeToCalculationPeriodDates, _that.getDateRelativeToCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.dateRelativeToValuationDates, _that.getDateRelativeToValuationDates())) {
                return false;
            }
            return Objects.equals(this.fxFixingDate, _that.getFxFixingDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessDayConvention != null ? ((Object)((Object)this.businessDayConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            _result = 31 * _result + (this.businessCentersReference != null ? this.businessCentersReference.hashCode() : 0);
            _result = 31 * _result + (this.dateRelativeToPaymentDates != null ? this.dateRelativeToPaymentDates.hashCode() : 0);
            _result = 31 * _result + (this.dateRelativeToCalculationPeriodDates != null ? this.dateRelativeToCalculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.dateRelativeToValuationDates != null ? this.dateRelativeToValuationDates.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingDate != null ? this.fxFixingDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxFixingDateBuilder {businessDayConvention=" + (Object)((Object)this.businessDayConvention) + ", businessCenters=" + this.businessCenters + ", businessCentersReference=" + this.businessCentersReference + ", dateRelativeToPaymentDates=" + this.dateRelativeToPaymentDates + ", dateRelativeToCalculationPeriodDates=" + this.dateRelativeToCalculationPeriodDates + ", dateRelativeToValuationDates=" + this.dateRelativeToValuationDates + ", fxFixingDate=" + this.fxFixingDate + '}' + " " + super.toString();
        }
    }

    public static class FxFixingDateImpl
    extends Offset.OffsetImpl
    implements FxFixingDate {
        private final BusinessDayConventionEnum businessDayConvention;
        private final BusinessCenters businessCenters;
        private final ReferenceWithMetaBusinessCenters businessCentersReference;
        private final DateRelativeToPaymentDates dateRelativeToPaymentDates;
        private final DateRelativeToCalculationPeriodDates dateRelativeToCalculationPeriodDates;
        private final DateRelativeToValuationDates dateRelativeToValuationDates;
        private final AdjustableOrRelativeDate fxFixingDate;

        protected FxFixingDateImpl(FxFixingDateBuilder builder) {
            super(builder);
            this.businessDayConvention = builder.getBusinessDayConvention();
            this.businessCenters = Optional.ofNullable(builder.getBusinessCenters()).map(f -> f.build()).orElse(null);
            this.businessCentersReference = Optional.ofNullable(builder.getBusinessCentersReference()).map(f -> f.build()).orElse(null);
            this.dateRelativeToPaymentDates = Optional.ofNullable(builder.getDateRelativeToPaymentDates()).map(f -> f.build()).orElse(null);
            this.dateRelativeToCalculationPeriodDates = Optional.ofNullable(builder.getDateRelativeToCalculationPeriodDates()).map(f -> f.build()).orElse(null);
            this.dateRelativeToValuationDates = Optional.ofNullable(builder.getDateRelativeToValuationDates()).map(f -> f.build()).orElse(null);
            this.fxFixingDate = Optional.ofNullable(builder.getFxFixingDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="businessDayConvention")
        public BusinessDayConventionEnum getBusinessDayConvention() {
            return this.businessDayConvention;
        }

        @Override
        @RosettaAttribute(value="businessCenters")
        public BusinessCenters getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        @RosettaAttribute(value="businessCentersReference")
        public ReferenceWithMetaBusinessCenters getBusinessCentersReference() {
            return this.businessCentersReference;
        }

        @Override
        @RosettaAttribute(value="dateRelativeToPaymentDates")
        public DateRelativeToPaymentDates getDateRelativeToPaymentDates() {
            return this.dateRelativeToPaymentDates;
        }

        @Override
        @RosettaAttribute(value="dateRelativeToCalculationPeriodDates")
        public DateRelativeToCalculationPeriodDates getDateRelativeToCalculationPeriodDates() {
            return this.dateRelativeToCalculationPeriodDates;
        }

        @Override
        @RosettaAttribute(value="dateRelativeToValuationDates")
        public DateRelativeToValuationDates getDateRelativeToValuationDates() {
            return this.dateRelativeToValuationDates;
        }

        @Override
        @RosettaAttribute(value="fxFixingDate")
        public AdjustableOrRelativeDate getFxFixingDate() {
            return this.fxFixingDate;
        }

        @Override
        public FxFixingDate build() {
            return this;
        }

        @Override
        public FxFixingDateBuilder toBuilder() {
            FxFixingDateBuilder builder = FxFixingDate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxFixingDateBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBusinessDayConvention()).ifPresent(builder::setBusinessDayConvention);
            Optional.ofNullable(this.getBusinessCenters()).ifPresent(builder::setBusinessCenters);
            Optional.ofNullable(this.getBusinessCentersReference()).ifPresent(builder::setBusinessCentersReference);
            Optional.ofNullable(this.getDateRelativeToPaymentDates()).ifPresent(builder::setDateRelativeToPaymentDates);
            Optional.ofNullable(this.getDateRelativeToCalculationPeriodDates()).ifPresent(builder::setDateRelativeToCalculationPeriodDates);
            Optional.ofNullable(this.getDateRelativeToValuationDates()).ifPresent(builder::setDateRelativeToValuationDates);
            Optional.ofNullable(this.getFxFixingDate()).ifPresent(builder::setFxFixingDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxFixingDate _that = (FxFixingDate)this.getType().cast(o);
            if (!Objects.equals((Object)this.businessDayConvention, (Object)_that.getBusinessDayConvention())) {
                return false;
            }
            if (!Objects.equals(this.businessCenters, _that.getBusinessCenters())) {
                return false;
            }
            if (!Objects.equals(this.businessCentersReference, _that.getBusinessCentersReference())) {
                return false;
            }
            if (!Objects.equals(this.dateRelativeToPaymentDates, _that.getDateRelativeToPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.dateRelativeToCalculationPeriodDates, _that.getDateRelativeToCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.dateRelativeToValuationDates, _that.getDateRelativeToValuationDates())) {
                return false;
            }
            return Objects.equals(this.fxFixingDate, _that.getFxFixingDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessDayConvention != null ? ((Object)((Object)this.businessDayConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            _result = 31 * _result + (this.businessCentersReference != null ? this.businessCentersReference.hashCode() : 0);
            _result = 31 * _result + (this.dateRelativeToPaymentDates != null ? this.dateRelativeToPaymentDates.hashCode() : 0);
            _result = 31 * _result + (this.dateRelativeToCalculationPeriodDates != null ? this.dateRelativeToCalculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.dateRelativeToValuationDates != null ? this.dateRelativeToValuationDates.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingDate != null ? this.fxFixingDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxFixingDate {businessDayConvention=" + (Object)((Object)this.businessDayConvention) + ", businessCenters=" + this.businessCenters + ", businessCentersReference=" + this.businessCentersReference + ", dateRelativeToPaymentDates=" + this.dateRelativeToPaymentDates + ", dateRelativeToCalculationPeriodDates=" + this.dateRelativeToCalculationPeriodDates + ", dateRelativeToValuationDates=" + this.dateRelativeToValuationDates + ", fxFixingDate=" + this.fxFixingDate + '}' + " " + super.toString();
        }
    }

    public static interface FxFixingDateBuilder
    extends FxFixingDate,
    Offset.OffsetBuilder,
    RosettaModelObjectBuilder {
        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters();

        @Override
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters();

        public ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder getOrCreateBusinessCentersReference();

        @Override
        public ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder getBusinessCentersReference();

        public DateRelativeToPaymentDates.DateRelativeToPaymentDatesBuilder getOrCreateDateRelativeToPaymentDates();

        @Override
        public DateRelativeToPaymentDates.DateRelativeToPaymentDatesBuilder getDateRelativeToPaymentDates();

        public DateRelativeToCalculationPeriodDates.DateRelativeToCalculationPeriodDatesBuilder getOrCreateDateRelativeToCalculationPeriodDates();

        @Override
        public DateRelativeToCalculationPeriodDates.DateRelativeToCalculationPeriodDatesBuilder getDateRelativeToCalculationPeriodDates();

        public DateRelativeToValuationDates.DateRelativeToValuationDatesBuilder getOrCreateDateRelativeToValuationDates();

        @Override
        public DateRelativeToValuationDates.DateRelativeToValuationDatesBuilder getDateRelativeToValuationDates();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateFxFixingDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getFxFixingDate();

        public FxFixingDateBuilder setBusinessDayConvention(BusinessDayConventionEnum var1);

        public FxFixingDateBuilder setBusinessCenters(BusinessCenters var1);

        public FxFixingDateBuilder setBusinessCentersReference(ReferenceWithMetaBusinessCenters var1);

        public FxFixingDateBuilder setBusinessCentersReferenceValue(BusinessCenters var1);

        public FxFixingDateBuilder setDateRelativeToPaymentDates(DateRelativeToPaymentDates var1);

        public FxFixingDateBuilder setDateRelativeToCalculationPeriodDates(DateRelativeToCalculationPeriodDates var1);

        public FxFixingDateBuilder setDateRelativeToValuationDates(DateRelativeToValuationDates var1);

        public FxFixingDateBuilder setFxFixingDate(AdjustableOrRelativeDate var1);

        @Override
        public FxFixingDateBuilder setDayType(DayTypeEnum var1);

        @Override
        public FxFixingDateBuilder setPeriodMultiplier(Integer var1);

        @Override
        public FxFixingDateBuilder setPeriod(PeriodEnum var1);

        @Override
        public FxFixingDateBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            Offset.OffsetBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("businessDayConvention"), BusinessDayConventionEnum.class, (Object)this.getBusinessDayConvention(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.BusinessCentersBuilder.class, this.getBusinessCenters(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCentersReference"), processor, ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder.class, this.getBusinessCentersReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateRelativeToPaymentDates"), processor, DateRelativeToPaymentDates.DateRelativeToPaymentDatesBuilder.class, this.getDateRelativeToPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateRelativeToCalculationPeriodDates"), processor, DateRelativeToCalculationPeriodDates.DateRelativeToCalculationPeriodDatesBuilder.class, this.getDateRelativeToCalculationPeriodDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateRelativeToValuationDates"), processor, DateRelativeToValuationDates.DateRelativeToValuationDatesBuilder.class, this.getDateRelativeToValuationDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFixingDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getFxFixingDate(), new AttributeMeta[0]);
        }

        @Override
        public FxFixingDateBuilder prune();
    }
}

