/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.observable.asset.Money;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.GetQuantityScheduleStepValues;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetNotionalAmountDefault.class)
public abstract class GetNotionalAmount
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetQuantityScheduleStepValues getQuantityScheduleStepValues;

    public Money evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
        Money notional;
        Money.MoneyBuilder notionalBuilder = this.doEvaluate(interestRatePayout, calculationPeriod);
        if (notionalBuilder == null) {
            notional = null;
        } else {
            notional = notionalBuilder.build();
            this.objectValidator.validate(Money.class, (RosettaModelObject)notional);
        }
        return notional;
    }

    protected abstract Money.MoneyBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2);

    public static class GetNotionalAmountDefault
    extends GetNotionalAmount {
        @Override
        protected Money.MoneyBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            Money.MoneyBuilder notional = Money.builder();
            return this.assignOutput(notional, interestRatePayout, calculationPeriod);
        }

        protected Money.MoneyBuilder assignOutput(Money.MoneyBuilder notional, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            notional.setValue((BigDecimal)MapperC.of(this.getQuantityScheduleStepValues.evaluate((NonNegativeQuantitySchedule)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).get(), (Date)MapperS.of((Object)calculationPeriod).map("getAdjustedStartDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedStartDate()).get())).last().get());
            notional.getOrCreateUnit().setCurrencyValue((String)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()).get());
            return Optional.ofNullable(notional).map(o -> o.prune()).orElse(null);
        }
    }
}

