/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.math.Quantity;
import cdm.observable.asset.Price;
import cdm.product.asset.AssetDeliveryPeriods;
import cdm.product.asset.AssetDeliveryProfile;
import cdm.product.asset.meta.CalculationScheduleDeliveryPeriodsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CalculationScheduleDeliveryPeriods", builder=CalculationScheduleDeliveryPeriodsBuilderImpl.class, version="5.0.0")
public interface CalculationScheduleDeliveryPeriods
extends AssetDeliveryPeriods {
    public static final CalculationScheduleDeliveryPeriodsMeta metaData = new CalculationScheduleDeliveryPeriodsMeta();

    public Quantity getDeliveryCapacity();

    public Price getPriceTimeIntervalQuantity();

    @Override
    public CalculationScheduleDeliveryPeriods build();

    @Override
    public CalculationScheduleDeliveryPeriodsBuilder toBuilder();

    public static CalculationScheduleDeliveryPeriodsBuilder builder() {
        return new CalculationScheduleDeliveryPeriodsBuilderImpl();
    }

    default public RosettaMetaData<? extends CalculationScheduleDeliveryPeriods> metaData() {
        return metaData;
    }

    default public Class<? extends CalculationScheduleDeliveryPeriods> getType() {
        return CalculationScheduleDeliveryPeriods.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        AssetDeliveryPeriods.super.process(path, processor);
        this.processRosetta(path.newSubPath("deliveryCapacity"), processor, Quantity.class, this.getDeliveryCapacity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceTimeIntervalQuantity"), processor, Price.class, this.getPriceTimeIntervalQuantity(), new AttributeMeta[0]);
    }

    public static class CalculationScheduleDeliveryPeriodsBuilderImpl
    extends AssetDeliveryPeriods.AssetDeliveryPeriodsBuilderImpl
    implements CalculationScheduleDeliveryPeriodsBuilder {
        protected Quantity.QuantityBuilder deliveryCapacity;
        protected Price.PriceBuilder priceTimeIntervalQuantity;

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        public Quantity.QuantityBuilder getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        public Quantity.QuantityBuilder getOrCreateDeliveryCapacity() {
            Quantity.QuantityBuilder result = this.deliveryCapacity != null ? this.deliveryCapacity : (this.deliveryCapacity = Quantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceTimeIntervalQuantity")
        public Price.PriceBuilder getPriceTimeIntervalQuantity() {
            return this.priceTimeIntervalQuantity;
        }

        @Override
        public Price.PriceBuilder getOrCreatePriceTimeIntervalQuantity() {
            Price.PriceBuilder result = this.priceTimeIntervalQuantity != null ? this.priceTimeIntervalQuantity : (this.priceTimeIntervalQuantity = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        public CalculationScheduleDeliveryPeriodsBuilder setDeliveryCapacity(Quantity deliveryCapacity) {
            this.deliveryCapacity = deliveryCapacity == null ? null : deliveryCapacity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceTimeIntervalQuantity")
        public CalculationScheduleDeliveryPeriodsBuilder setPriceTimeIntervalQuantity(Price priceTimeIntervalQuantity) {
            this.priceTimeIntervalQuantity = priceTimeIntervalQuantity == null ? null : priceTimeIntervalQuantity.toBuilder();
            return this;
        }

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder addProfile(AssetDeliveryProfile profile) {
            if (profile != null) {
                this.profile.add(profile.toBuilder());
            }
            return this;
        }

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder addProfile(AssetDeliveryProfile profile, int _idx) {
            this.getIndex(this.profile, _idx, () -> profile.toBuilder());
            return this;
        }

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder addProfile(List<? extends AssetDeliveryProfile> profiles) {
            if (profiles != null) {
                for (AssetDeliveryProfile assetDeliveryProfile : profiles) {
                    this.profile.add(assetDeliveryProfile.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="profile")
        public CalculationScheduleDeliveryPeriodsBuilder setProfile(List<? extends AssetDeliveryProfile> profiles) {
            this.profile = profiles == null ? new ArrayList() : (List)profiles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="startDate")
        public CalculationScheduleDeliveryPeriodsBuilder setStartDate(Date startDate) {
            this.startDate = startDate == null ? null : startDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="endDate")
        public CalculationScheduleDeliveryPeriodsBuilder setEndDate(Date endDate) {
            this.endDate = endDate == null ? null : endDate;
            return this;
        }

        @Override
        public CalculationScheduleDeliveryPeriods build() {
            return new CalculationScheduleDeliveryPeriodsImpl(this);
        }

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder prune() {
            super.prune();
            if (this.deliveryCapacity != null && !this.deliveryCapacity.prune().hasData()) {
                this.deliveryCapacity = null;
            }
            if (this.priceTimeIntervalQuantity != null && !this.priceTimeIntervalQuantity.prune().hasData()) {
                this.priceTimeIntervalQuantity = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeliveryCapacity() != null && this.getDeliveryCapacity().hasData()) {
                return true;
            }
            return this.getPriceTimeIntervalQuantity() != null && this.getPriceTimeIntervalQuantity().hasData();
        }

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CalculationScheduleDeliveryPeriodsBuilder o = (CalculationScheduleDeliveryPeriodsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryCapacity(), (RosettaModelObjectBuilder)o.getDeliveryCapacity(), this::setDeliveryCapacity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceTimeIntervalQuantity(), (RosettaModelObjectBuilder)o.getPriceTimeIntervalQuantity(), this::setPriceTimeIntervalQuantity);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CalculationScheduleDeliveryPeriods _that = (CalculationScheduleDeliveryPeriods)this.getType().cast(o);
            if (!Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity())) {
                return false;
            }
            return Objects.equals(this.priceTimeIntervalQuantity, _that.getPriceTimeIntervalQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            _result = 31 * _result + (this.priceTimeIntervalQuantity != null ? this.priceTimeIntervalQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CalculationScheduleDeliveryPeriodsBuilder {deliveryCapacity=" + this.deliveryCapacity + ", priceTimeIntervalQuantity=" + this.priceTimeIntervalQuantity + '}' + " " + super.toString();
        }
    }

    public static class CalculationScheduleDeliveryPeriodsImpl
    extends AssetDeliveryPeriods.AssetDeliveryPeriodsImpl
    implements CalculationScheduleDeliveryPeriods {
        private final Quantity deliveryCapacity;
        private final Price priceTimeIntervalQuantity;

        protected CalculationScheduleDeliveryPeriodsImpl(CalculationScheduleDeliveryPeriodsBuilder builder) {
            super(builder);
            this.deliveryCapacity = Optional.ofNullable(builder.getDeliveryCapacity()).map(f -> f.build()).orElse(null);
            this.priceTimeIntervalQuantity = Optional.ofNullable(builder.getPriceTimeIntervalQuantity()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        public Quantity getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        @RosettaAttribute(value="priceTimeIntervalQuantity")
        public Price getPriceTimeIntervalQuantity() {
            return this.priceTimeIntervalQuantity;
        }

        @Override
        public CalculationScheduleDeliveryPeriods build() {
            return this;
        }

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder toBuilder() {
            CalculationScheduleDeliveryPeriodsBuilder builder = CalculationScheduleDeliveryPeriods.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculationScheduleDeliveryPeriodsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeliveryCapacity()).ifPresent(builder::setDeliveryCapacity);
            Optional.ofNullable(this.getPriceTimeIntervalQuantity()).ifPresent(builder::setPriceTimeIntervalQuantity);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CalculationScheduleDeliveryPeriods _that = (CalculationScheduleDeliveryPeriods)this.getType().cast(o);
            if (!Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity())) {
                return false;
            }
            return Objects.equals(this.priceTimeIntervalQuantity, _that.getPriceTimeIntervalQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            _result = 31 * _result + (this.priceTimeIntervalQuantity != null ? this.priceTimeIntervalQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CalculationScheduleDeliveryPeriods {deliveryCapacity=" + this.deliveryCapacity + ", priceTimeIntervalQuantity=" + this.priceTimeIntervalQuantity + '}' + " " + super.toString();
        }
    }

    public static interface CalculationScheduleDeliveryPeriodsBuilder
    extends CalculationScheduleDeliveryPeriods,
    AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder,
    RosettaModelObjectBuilder {
        public Quantity.QuantityBuilder getOrCreateDeliveryCapacity();

        @Override
        public Quantity.QuantityBuilder getDeliveryCapacity();

        public Price.PriceBuilder getOrCreatePriceTimeIntervalQuantity();

        @Override
        public Price.PriceBuilder getPriceTimeIntervalQuantity();

        public CalculationScheduleDeliveryPeriodsBuilder setDeliveryCapacity(Quantity var1);

        public CalculationScheduleDeliveryPeriodsBuilder setPriceTimeIntervalQuantity(Price var1);

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder addProfile(AssetDeliveryProfile var1);

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder addProfile(AssetDeliveryProfile var1, int var2);

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder addProfile(List<? extends AssetDeliveryProfile> var1);

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder setProfile(List<? extends AssetDeliveryProfile> var1);

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder setStartDate(Date var1);

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder setEndDate(Date var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("deliveryCapacity"), processor, Quantity.QuantityBuilder.class, this.getDeliveryCapacity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceTimeIntervalQuantity"), processor, Price.PriceBuilder.class, this.getPriceTimeIntervalQuantity(), new AttributeMeta[0]);
        }

        @Override
        public CalculationScheduleDeliveryPeriodsBuilder prune();
    }
}

