/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.Price;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceAmountOnlyExists")
@ImplementedBy(value=Default.class)
public interface PriceAmountOnlyExists
extends Validator<Price> {
    public static final String NAME = "PriceAmountOnlyExists";
    public static final String DEFINITION = "value exists and datedValue is absent";

    public ValidationResult<Price> validate(RosettaPath var1, Price var2);

    public static class NoOp
    implements PriceAmountOnlyExists {
        @Override
        public ValidationResult<Price> validate(RosettaPath path, Price price) {
            return ValidationResult.success((String)PriceAmountOnlyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Price", (RosettaPath)path, (String)PriceAmountOnlyExists.DEFINITION);
        }
    }

    public static class Default
    implements PriceAmountOnlyExists {
        @Override
        public ValidationResult<Price> validate(RosettaPath path, Price price) {
            ComparisonResult result = this.executeDataRule(price);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceAmountOnlyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Price", (RosettaPath)path, (String)PriceAmountOnlyExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceAmountOnlyExists failed.";
            }
            return ValidationResult.failure((String)PriceAmountOnlyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Price", (RosettaPath)path, (String)PriceAmountOnlyExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Price price) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)price).map("getValue", measureBase -> measureBase.getValue())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)price).mapC("getDatedValue", measureSchedule -> measureSchedule.getDatedValue())));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

