/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.Observable;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="ObservableObservableChoice")
@ImplementedBy(value=Default.class)
public interface ObservableObservableChoice
extends Validator<Observable> {
    public static final String NAME = "ObservableObservableChoice";
    public static final String DEFINITION = "required choice rateOption, commodity, productIdentifier, currencyPair";

    public ValidationResult<Observable> validate(RosettaPath var1, Observable var2);

    public static class NoOp
    implements ObservableObservableChoice {
        @Override
        public ValidationResult<Observable> validate(RosettaPath path, Observable observable) {
            return ValidationResult.success((String)ObservableObservableChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Observable", (RosettaPath)path, (String)ObservableObservableChoice.DEFINITION);
        }
    }

    public static class Default
    implements ObservableObservableChoice {
        @Override
        public ValidationResult<Observable> validate(RosettaPath path, Observable observable) {
            ComparisonResult result = this.executeDataRule(observable);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ObservableObservableChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Observable", (RosettaPath)path, (String)ObservableObservableChoice.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ObservableObservableChoice failed.";
            }
            return ValidationResult.failure((String)ObservableObservableChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Observable", (RosettaPath)path, (String)ObservableObservableChoice.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Observable observable) {
            try {
                ComparisonResult result = ExpressionOperators.choice((Mapper)MapperS.of((Object)observable), Arrays.asList("rateOption", "commodity", "productIdentifier", "currencyPair"), (ValidationResult.ChoiceRuleValidationMethod)ValidationResult.ChoiceRuleValidationMethod.REQUIRED);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

