/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.master;

import cdm.legaldocumentation.master.meta.ClauseMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Clause", builder=ClauseBuilderImpl.class, version="5.0.0")
public interface Clause
extends RosettaModelObject {
    public static final ClauseMeta metaData = new ClauseMeta();

    public String getIdentifier();

    public String getTerms();

    public List<? extends Clause> getSubcomponents();

    public Clause build();

    public ClauseBuilder toBuilder();

    public static ClauseBuilder builder() {
        return new ClauseBuilderImpl();
    }

    default public RosettaMetaData<? extends Clause> metaData() {
        return metaData;
    }

    default public Class<? extends Clause> getType() {
        return Clause.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("identifier"), String.class, (Object)this.getIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("terms"), String.class, (Object)this.getTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("subcomponents"), processor, Clause.class, this.getSubcomponents(), new AttributeMeta[0]);
    }

    public static class ClauseBuilderImpl
    implements ClauseBuilder {
        protected String identifier;
        protected String terms;
        protected List<ClauseBuilder> subcomponents = new ArrayList<ClauseBuilder>();

        @Override
        @RosettaAttribute(value="identifier")
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        @RosettaAttribute(value="terms")
        public String getTerms() {
            return this.terms;
        }

        @Override
        @RosettaAttribute(value="subcomponents")
        public List<? extends ClauseBuilder> getSubcomponents() {
            return this.subcomponents;
        }

        @Override
        public ClauseBuilder getOrCreateSubcomponents(int _index) {
            if (this.subcomponents == null) {
                this.subcomponents = new ArrayList<ClauseBuilder>();
            }
            return (ClauseBuilder)this.getIndex(this.subcomponents, _index, () -> {
                ClauseBuilder newSubcomponents = Clause.builder();
                return newSubcomponents;
            });
        }

        @Override
        @RosettaAttribute(value="identifier")
        public ClauseBuilder setIdentifier(String identifier) {
            this.identifier = identifier == null ? null : identifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="terms")
        public ClauseBuilder setTerms(String terms) {
            this.terms = terms == null ? null : terms;
            return this;
        }

        @Override
        public ClauseBuilder addSubcomponents(Clause subcomponents) {
            if (subcomponents != null) {
                this.subcomponents.add(subcomponents.toBuilder());
            }
            return this;
        }

        @Override
        public ClauseBuilder addSubcomponents(Clause subcomponents, int _idx) {
            this.getIndex(this.subcomponents, _idx, () -> subcomponents.toBuilder());
            return this;
        }

        @Override
        public ClauseBuilder addSubcomponents(List<? extends Clause> subcomponentss) {
            if (subcomponentss != null) {
                for (Clause clause : subcomponentss) {
                    this.subcomponents.add(clause.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="subcomponents")
        public ClauseBuilder setSubcomponents(List<? extends Clause> subcomponentss) {
            this.subcomponents = subcomponentss == null ? new ArrayList<ClauseBuilder>() : (List)subcomponentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Clause build() {
            return new ClauseImpl(this);
        }

        @Override
        public ClauseBuilder toBuilder() {
            return this;
        }

        @Override
        public ClauseBuilder prune() {
            this.subcomponents = this.subcomponents.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIdentifier() != null) {
                return true;
            }
            if (this.getTerms() != null) {
                return true;
            }
            return this.getSubcomponents() != null && this.getSubcomponents().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ClauseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ClauseBuilder o = (ClauseBuilder)other;
            merger.mergeRosetta(this.getSubcomponents(), o.getSubcomponents(), this::getOrCreateSubcomponents);
            merger.mergeBasic((Object)this.getIdentifier(), (Object)o.getIdentifier(), this::setIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTerms(), (Object)o.getTerms(), this::setTerms, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Clause _that = this.getType().cast(o);
            if (!Objects.equals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.terms, _that.getTerms())) {
                return false;
            }
            return ListEquals.listEquals(this.subcomponents, _that.getSubcomponents());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.terms != null ? this.terms.hashCode() : 0);
            _result = 31 * _result + (this.subcomponents != null ? this.subcomponents.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ClauseBuilder {identifier=" + this.identifier + ", terms=" + this.terms + ", subcomponents=" + this.subcomponents + '}';
        }
    }

    public static class ClauseImpl
    implements Clause {
        private final String identifier;
        private final String terms;
        private final List<? extends Clause> subcomponents;

        protected ClauseImpl(ClauseBuilder builder) {
            this.identifier = builder.getIdentifier();
            this.terms = builder.getTerms();
            this.subcomponents = Optional.ofNullable(builder.getSubcomponents()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="identifier")
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        @RosettaAttribute(value="terms")
        public String getTerms() {
            return this.terms;
        }

        @Override
        @RosettaAttribute(value="subcomponents")
        public List<? extends Clause> getSubcomponents() {
            return this.subcomponents;
        }

        @Override
        public Clause build() {
            return this;
        }

        @Override
        public ClauseBuilder toBuilder() {
            ClauseBuilder builder = Clause.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ClauseBuilder builder) {
            Optional.ofNullable(this.getIdentifier()).ifPresent(builder::setIdentifier);
            Optional.ofNullable(this.getTerms()).ifPresent(builder::setTerms);
            Optional.ofNullable(this.getSubcomponents()).ifPresent(builder::setSubcomponents);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Clause _that = this.getType().cast(o);
            if (!Objects.equals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.terms, _that.getTerms())) {
                return false;
            }
            return ListEquals.listEquals(this.subcomponents, _that.getSubcomponents());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.terms != null ? this.terms.hashCode() : 0);
            _result = 31 * _result + (this.subcomponents != null ? this.subcomponents.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Clause {identifier=" + this.identifier + ", terms=" + this.terms + ", subcomponents=" + this.subcomponents + '}';
        }
    }

    public static interface ClauseBuilder
    extends Clause,
    RosettaModelObjectBuilder {
        public ClauseBuilder getOrCreateSubcomponents(int var1);

        public List<? extends ClauseBuilder> getSubcomponents();

        public ClauseBuilder setIdentifier(String var1);

        public ClauseBuilder setTerms(String var1);

        public ClauseBuilder addSubcomponents(Clause var1);

        public ClauseBuilder addSubcomponents(Clause var1, int var2);

        public ClauseBuilder addSubcomponents(List<? extends Clause> var1);

        public ClauseBuilder setSubcomponents(List<? extends Clause> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("identifier"), String.class, (Object)this.getIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("terms"), String.class, (Object)this.getTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("subcomponents"), processor, ClauseBuilder.class, this.getSubcomponents(), new AttributeMeta[0]);
        }

        public ClauseBuilder prune();
    }
}

