/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common.validation.datarule;

import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.LegalAgreementTypeEnum;
import cdm.product.collateral.CreditSupportAgreementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="LegalAgreementAgreementVerification")
@ImplementedBy(value=Default.class)
public interface LegalAgreementAgreementVerification
extends Validator<LegalAgreement> {
    public static final String NAME = "LegalAgreementAgreementVerification";
    public static final String DEFINITION = "if agreementTerms -> agreement -> securityAgreementElections exists then legalAgreementIdentification -> agreementName -> agreementType = LegalAgreementTypeEnum -> SecurityAgreement else if agreementTerms -> agreement -> creditSupportAgreementElections exists then legalAgreementIdentification -> agreementName -> creditSupportAgreementType = CreditSupportAgreementTypeEnum -> CreditSupportAnnex or legalAgreementIdentification -> agreementName -> creditSupportAgreementType = CreditSupportAgreementTypeEnum -> CreditSupportDeed else if agreementTerms -> agreement -> collateralTransferAgreementElections exists then legalAgreementIdentification -> agreementName -> creditSupportAgreementType = CreditSupportAgreementTypeEnum -> CollateralTransferAgreement else if agreementTerms -> agreement -> masterAgreementSchedule exists then legalAgreementIdentification -> agreementName -> agreementType = LegalAgreementTypeEnum -> MasterAgreement";

    public ValidationResult<LegalAgreement> validate(RosettaPath var1, LegalAgreement var2);

    public static class NoOp
    implements LegalAgreementAgreementVerification {
        @Override
        public ValidationResult<LegalAgreement> validate(RosettaPath path, LegalAgreement legalAgreement) {
            return ValidationResult.success((String)LegalAgreementAgreementVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementAgreementVerification.DEFINITION);
        }
    }

    public static class Default
    implements LegalAgreementAgreementVerification {
        @Override
        public ValidationResult<LegalAgreement> validate(RosettaPath path, LegalAgreement legalAgreement) {
            ComparisonResult result = this.executeDataRule(legalAgreement);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)LegalAgreementAgreementVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementAgreementVerification.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition LegalAgreementAgreementVerification failed.";
            }
            return ValidationResult.failure((String)LegalAgreementAgreementVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementAgreementVerification.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(LegalAgreement legalAgreement) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementTerms", _legalAgreement -> _legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getSecurityAgreementElections", agreement -> agreement.getSecurityAgreementElections())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", legalAgreementBase -> legalAgreementBase.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getAgreementType", agreementName -> agreementName.getAgreementType()), (Mapper)MapperS.of((Object)((Object)LegalAgreementTypeEnum.SECURITY_AGREEMENT)), (CardinalityOperator)CardinalityOperator.All);
                    }
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementTerms", _legalAgreement -> _legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getCreditSupportAgreementElections", agreement -> agreement.getCreditSupportAgreementElections())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", legalAgreementBase -> legalAgreementBase.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getCreditSupportAgreementType", agreementName -> agreementName.getCreditSupportAgreementType()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)((Object)CreditSupportAgreementTypeEnum.CREDIT_SUPPORT_ANNEX)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", legalAgreementBase -> legalAgreementBase.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getCreditSupportAgreementType", agreementName -> agreementName.getCreditSupportAgreementType()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)((Object)CreditSupportAgreementTypeEnum.CREDIT_SUPPORT_DEED)), (CardinalityOperator)CardinalityOperator.All));
                    }
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementTerms", _legalAgreement -> _legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getCollateralTransferAgreementElections", agreement -> agreement.getCollateralTransferAgreementElections())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", legalAgreementBase -> legalAgreementBase.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getCreditSupportAgreementType", agreementName -> agreementName.getCreditSupportAgreementType()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)((Object)CreditSupportAgreementTypeEnum.COLLATERAL_TRANSFER_AGREEMENT)), (CardinalityOperator)CardinalityOperator.All);
                    }
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementTerms", _legalAgreement -> _legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getMasterAgreementSchedule", agreement -> agreement.getMasterAgreementSchedule())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legalAgreement).map("getLegalAgreementIdentification", legalAgreementBase -> legalAgreementBase.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getAgreementType", agreementName -> agreementName.getAgreementType()), (Mapper)MapperS.of((Object)((Object)LegalAgreementTypeEnum.MASTER_AGREEMENT)), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

