/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradeDisruptionEventsDeterminingParty")
@ImplementedBy(value=Default.class)
public interface TradeDisruptionEventsDeterminingParty
extends Validator<Trade> {
    public static final String NAME = "TradeDisruptionEventsDeterminingParty";
    public static final String DEFINITION = "if contractDetails -> documentation -> agreementTerms -> agreement -> transactionAdditionalTerms -> equityAdditionalTerms -> extraordinaryEvents -> additionalDisruptionEvents -> determiningParty exists then tradableProduct -> ancillaryParty -> role contains AncillaryRoleEnum -> DisruptionEventsDeterminingParty and if tradableProduct -> ancillaryParty -> role contains AncillaryRoleEnum -> DisruptionEventsDeterminingParty then contractDetails -> documentation -> agreementTerms -> agreement -> transactionAdditionalTerms -> equityAdditionalTerms -> extraordinaryEvents -> additionalDisruptionEvents -> determiningParty exists";

    public ValidationResult<Trade> validate(RosettaPath var1, Trade var2);

    public static class NoOp
    implements TradeDisruptionEventsDeterminingParty {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            return ValidationResult.success((String)TradeDisruptionEventsDeterminingParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeDisruptionEventsDeterminingParty.DEFINITION);
        }
    }

    public static class Default
    implements TradeDisruptionEventsDeterminingParty {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradeDisruptionEventsDeterminingParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeDisruptionEventsDeterminingParty.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradeDisruptionEventsDeterminingParty failed.";
            }
            return ValidationResult.failure((String)TradeDisruptionEventsDeterminingParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeDisruptionEventsDeterminingParty.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getAgreementTerms", legalAgreement -> legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getTransactionAdditionalTerms", agreement -> agreement.getTransactionAdditionalTerms()).map("getEquityAdditionalTerms", transactionAdditionalTerms -> transactionAdditionalTerms.getEquityAdditionalTerms()).map("getExtraordinaryEvents", equityAdditionalTerms -> equityAdditionalTerms.getExtraordinaryEvents()).map("getAdditionalDisruptionEvents", extraordinaryEvents -> extraordinaryEvents.getAdditionalDisruptionEvents()).map("getDeterminingParty", additionalDisruptionEvents -> additionalDisruptionEvents.getDeterminingParty())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getAncillaryParty", tradableProduct -> tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.DISRUPTION_EVENTS_DETERMINING_PARTY))).and(MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                            if (ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getAncillaryParty", tradableProduct -> tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.DISRUPTION_EVENTS_DETERMINING_PARTY))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                                return ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getAgreementTerms", legalAgreement -> legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getTransactionAdditionalTerms", agreement -> agreement.getTransactionAdditionalTerms()).map("getEquityAdditionalTerms", transactionAdditionalTerms -> transactionAdditionalTerms.getEquityAdditionalTerms()).map("getExtraordinaryEvents", equityAdditionalTerms -> equityAdditionalTerms.getExtraordinaryEvents()).map("getAdditionalDisruptionEvents", extraordinaryEvents -> extraordinaryEvents.getAdditionalDisruptionEvents()).map("getDeterminingParty", additionalDisruptionEvents -> additionalDisruptionEvents.getDeterminingParty()));
                            }
                            return null;
                        })));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

