/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.asset.common.DebtClassEnum;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.event.common.Trade;
import cdm.legaldocumentation.common.ContractualSupplementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradeCreditEventsMortgages")
@ImplementedBy(value=Default.class)
public interface TradeCreditEventsMortgages
extends Validator<Trade> {
    public static final String NAME = "TradeCreditEventsMortgages";
    public static final String DEFINITION = "if ((tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> generalTerms -> referenceInformation -> referenceObligation -> security -> securityType any = SecurityTypeEnum -> Debt and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> generalTerms -> referenceInformation -> referenceObligation -> security -> debtType -> debtClass any = DebtClassEnum -> AssetBacked) or contractDetails -> documentation -> legalAgreementIdentification -> agreementName -> contractualTermsSupplement -> contractualTermsSupplementType contains ContractualSupplementTypeEnum -> CDSonMBS) and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> protectionTerms -> creditEvents exists then (tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> protectionTerms -> creditEvents -> failureToPayPrincipal exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> protectionTerms -> creditEvents -> failureToPayInterest exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> protectionTerms -> creditEvents -> distressedRatingsDowngrade exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> protectionTerms -> creditEvents -> maturityExtension exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> protectionTerms -> creditEvents -> writedown exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> protectionTerms -> creditEvents -> impliedWritedown exists)";

    public ValidationResult<Trade> validate(RosettaPath var1, Trade var2);

    public static class NoOp
    implements TradeCreditEventsMortgages {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            return ValidationResult.success((String)TradeCreditEventsMortgages.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeCreditEventsMortgages.DEFINITION);
        }
    }

    public static class Default
    implements TradeCreditEventsMortgages {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradeCreditEventsMortgages.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeCreditEventsMortgages.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradeCreditEventsMortgages failed.";
            }
            return ValidationResult.failure((String)TradeCreditEventsMortgages.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeCreditEventsMortgages.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).map("getSecurityType", security -> security.getSecurityType()), (Mapper)MapperS.of((Object)((Object)SecurityTypeEnum.DEBT)), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).map("getDebtType", security -> security.getDebtType()).map("getDebtClass", debtType -> debtType.getDebtClass()), (Mapper)MapperS.of((Object)((Object)DebtClassEnum.ASSET_BACKED)), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getLegalAgreementIdentification", legalAgreementBase -> legalAgreementBase.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).mapC("getContractualTermsSupplement", agreementName -> agreementName.getContractualTermsSupplement()).map("getContractualTermsSupplementType", contractualTermsSupplement -> contractualTermsSupplement.getContractualTermsSupplementType()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)((Object)ContractualSupplementTypeEnum.CD_SON_MBS)))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getCreditEvents", protectionTerms -> protectionTerms.getCreditEvents()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getCreditEvents", protectionTerms -> protectionTerms.getCreditEvents()).map("getFailureToPayPrincipal", creditEvents -> creditEvents.getFailureToPayPrincipal())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getCreditEvents", protectionTerms -> protectionTerms.getCreditEvents()).map("getFailureToPayInterest", creditEvents -> creditEvents.getFailureToPayInterest()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getCreditEvents", protectionTerms -> protectionTerms.getCreditEvents()).map("getDistressedRatingsDowngrade", creditEvents -> creditEvents.getDistressedRatingsDowngrade()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getCreditEvents", protectionTerms -> protectionTerms.getCreditEvents()).map("getMaturityExtension", creditEvents -> creditEvents.getMaturityExtension()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getCreditEvents", protectionTerms -> protectionTerms.getCreditEvents()).map("getWritedown", creditEvents -> creditEvents.getWritedown()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getCreditEvents", protectionTerms -> protectionTerms.getCreditEvents()).map("getImpliedWritedown", creditEvents -> creditEvents.getImpliedWritedown())));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

