/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.UnitType;
import cdm.event.common.QuantityChangeInstruction;
import cdm.observable.asset.CashPrice;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_OnDemandRateChangePriceChangeInstructionDefault.class)
public abstract class Create_OnDemandRateChangePriceChangeInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public QuantityChangeInstruction evaluate(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
        QuantityChangeInstruction quantityChangeInstruction;
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get()))), "There should be 1 and only 1 rate type price in the current price.");
        QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstructionBuilder = this.doEvaluate(priceQuantity, newRate);
        if (quantityChangeInstructionBuilder == null) {
            quantityChangeInstruction = null;
        } else {
            quantityChangeInstruction = quantityChangeInstructionBuilder.build();
            this.objectValidator.validate(QuantityChangeInstruction.class, (RosettaModelObject)quantityChangeInstruction);
        }
        return quantityChangeInstruction;
    }

    protected abstract QuantityChangeInstruction.QuantityChangeInstructionBuilder doEvaluate(List<? extends PriceQuantity> var1, BigDecimal var2);

    protected abstract Mapper<? extends PriceSchedule> currentRatePrice(List<? extends PriceQuantity> var1, BigDecimal var2);

    protected abstract Mapper<? extends Price> newPrice(List<? extends PriceQuantity> var1, BigDecimal var2);

    protected abstract Mapper<? extends PriceQuantity> newPriceQuantity(List<? extends PriceQuantity> var1, BigDecimal var2);

    public static class Create_OnDemandRateChangePriceChangeInstructionDefault
    extends Create_OnDemandRateChangePriceChangeInstruction {
        @Override
        protected QuantityChangeInstruction.QuantityChangeInstructionBuilder doEvaluate(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstruction = QuantityChangeInstruction.builder();
            return this.assignOutput(quantityChangeInstruction, priceQuantity, newRate);
        }

        protected QuantityChangeInstruction.QuantityChangeInstructionBuilder assignOutput(QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstruction, List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            quantityChangeInstruction = (QuantityChangeInstruction.QuantityChangeInstructionBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)QuantityChangeInstruction.builder().setChange(MapperS.of((Object)((PriceQuantity)this.newPriceQuantity(priceQuantity, newRate).get())).getMulti()).setDirection((QuantityChangeDirectionEnum)((Object)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.REPLACE)).get())).setLotIdentifier(MapperC.ofNull().getMulti()).build()).get());
            return Optional.ofNullable(quantityChangeInstruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends PriceSchedule> currentRatePrice(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            return (Mapper)((MapperC)((MapperC)MapperC.of(priceQuantity).mapItemToList(item -> item.mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("getValue", _f -> _f.getValue())).apply(item -> item.flattenList())).apply(item -> item.filterItemNullSafe(_item -> ExpressionOperators.areEqual((Mapper)_item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.All).get()))).apply(item -> MapperS.of((Object)((PriceSchedule)item.get())));
        }

        @Override
        protected Mapper<? extends Price> newPrice(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            return MapperS.of((Object)Price.builder().setValue((BigDecimal)MapperS.of((Object)newRate).get()).setUnit((UnitType)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getUnit", measureBase -> measureBase.getUnit()).get()).setPerUnitOf((UnitType)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).get()).setPriceType((PriceTypeEnum)((Object)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()).get())).setPriceExpression((PriceExpressionEnum)((Object)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).get())).setComposite((PriceComposite)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getComposite", priceSchedule -> priceSchedule.getComposite()).get()).setArithmeticOperator((ArithmeticOperationEnum)((Object)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()).get())).setCashPrice((CashPrice)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getCashPrice", priceSchedule -> priceSchedule.getCashPrice()).get()).setDatedValue(MapperC.ofNull().getMulti()).build());
        }

        @Override
        protected Mapper<? extends PriceQuantity> newPriceQuantity(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            return MapperS.of((Object)PriceQuantity.builder().setPriceValue(MapperS.of((Object)((Price)this.newPrice(priceQuantity, newRate).get())).getMulti()).build());
        }
    }
}

