/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.CashflowType;
import cdm.product.common.settlement.PaymentDiscounting;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_CashflowDefault.class)
public abstract class Create_Cashflow
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Cashflow evaluate(BigDecimal amount, String currency, SettlementDate settlementDate, PayerReceiver payerReceiver, CashflowType cashflowType, PaymentDiscounting paymentDiscounting) {
        Cashflow cashflow;
        Cashflow.CashflowBuilder cashflowBuilder = this.doEvaluate(amount, currency, settlementDate, payerReceiver, cashflowType, paymentDiscounting);
        if (cashflowBuilder == null) {
            cashflow = null;
        } else {
            cashflow = cashflowBuilder.build();
            this.objectValidator.validate(Cashflow.class, (RosettaModelObject)cashflow);
        }
        return cashflow;
    }

    protected abstract Cashflow.CashflowBuilder doEvaluate(BigDecimal var1, String var2, SettlementDate var3, PayerReceiver var4, CashflowType var5, PaymentDiscounting var6);

    public static class Create_CashflowDefault
    extends Create_Cashflow {
        @Override
        protected Cashflow.CashflowBuilder doEvaluate(BigDecimal amount, String currency, SettlementDate settlementDate, PayerReceiver payerReceiver, CashflowType cashflowType, PaymentDiscounting paymentDiscounting) {
            Cashflow.CashflowBuilder cashflow = Cashflow.builder();
            return this.assignOutput(cashflow, amount, currency, settlementDate, payerReceiver, cashflowType, paymentDiscounting);
        }

        protected Cashflow.CashflowBuilder assignOutput(Cashflow.CashflowBuilder cashflow, BigDecimal amount, String currency, SettlementDate settlementDate, PayerReceiver payerReceiver, CashflowType cashflowType, PaymentDiscounting paymentDiscounting) {
            cashflow.getOrCreateSettlementTerms().setSettlementDate((SettlementDate)MapperS.of((Object)settlementDate).get());
            cashflow.setPayerReceiver((PayerReceiver)MapperS.of((Object)payerReceiver).get());
            cashflow.setCashflowType((CashflowType)MapperS.of((Object)cashflowType).get());
            cashflow.setPaymentDiscounting((PaymentDiscounting)MapperS.of((Object)paymentDiscounting).get());
            cashflow.setPriceQuantity((ResolvablePriceQuantity)MapperS.of((Object)ResolvablePriceQuantity.builder().setQuantityScheduleValue((NonNegativeQuantitySchedule)MapperS.of((Object)NonNegativeQuantitySchedule.builder().setValue((BigDecimal)MapperS.of((Object)amount).get()).setUnit((UnitType)MapperS.of((Object)UnitType.builder().setCurrencyValue((String)MapperS.of((Object)currency).get()).build()).get()).build()).get()).build()).get());
            return Optional.ofNullable(cashflow).map(o -> o.prune()).orElse(null);
        }
    }
}

