/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="InstructionFunctionEnum")
public enum InstructionFunctionEnum {
    EXECUTION("Execution"),
    CONTRACT_FORMATION("ContractFormation"),
    QUANTITY_CHANGE("QuantityChange"),
    RENEGOTIATION("Renegotiation"),
    COMPRESSION("Compression");

    private static Map<String, InstructionFunctionEnum> values;
    private final String rosettaName;
    private final String displayName;

    private InstructionFunctionEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private InstructionFunctionEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static InstructionFunctionEnum fromDisplayName(String name) {
        InstructionFunctionEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, InstructionFunctionEnum> map = new ConcurrentHashMap<String, InstructionFunctionEnum>();
        for (InstructionFunctionEnum instance : InstructionFunctionEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

