/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="ExecutionTypeEnum")
public enum ExecutionTypeEnum {
    ELECTRONIC("Electronic"),
    OFF_FACILITY("OffFacility"),
    ON_VENUE("OnVenue");

    private static Map<String, ExecutionTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private ExecutionTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private ExecutionTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static ExecutionTypeEnum fromDisplayName(String name) {
        ExecutionTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, ExecutionTypeEnum> map = new ConcurrentHashMap<String, ExecutionTypeEnum>();
        for (ExecutionTypeEnum instance : ExecutionTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

