/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="CorporateActionTypeEnum")
public enum CorporateActionTypeEnum {
    CASH_DIVIDEND("CashDividend"),
    STOCK_DIVIDEND("StockDividend"),
    STOCK_SPLIT("StockSplit"),
    REVERSE_STOCK_SPLIT("ReverseStockSplit"),
    SPIN_OFF("SpinOff"),
    MERGER("Merger"),
    DELISTING("Delisting"),
    STOCK_NAME_CHANGE("StockNameChange"),
    STOCK_IDENTIFIER_CHANGE("StockIdentifierChange"),
    RIGHTS_ISSUE("RightsIssue"),
    TAKEOVER("Takeover"),
    STOCK_RECLASSIFICATION("StockReclassification"),
    BONUS_ISSUE("BonusIssue"),
    CLASS_ACTION("ClassAction"),
    EARLY_REDEMPTION("EarlyRedemption"),
    LIQUIDATION("Liquidation");

    private static Map<String, CorporateActionTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private CorporateActionTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private CorporateActionTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static CorporateActionTypeEnum fromDisplayName(String name) {
        CorporateActionTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, CorporateActionTypeEnum> map = new ConcurrentHashMap<String, CorporateActionTypeEnum>();
        for (CorporateActionTypeEnum instance : CorporateActionTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

