/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.common.functions.DifferentOrdinalsCondition;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import javax.inject.Inject;

@RosettaDataRule(value="TaxonomyDifferentOrdinals")
@ImplementedBy(value=Default.class)
public interface TaxonomyDifferentOrdinals
extends Validator<Taxonomy> {
    public static final String NAME = "TaxonomyDifferentOrdinals";
    public static final String DEFINITION = "if value -> classification -> ordinal exists then DifferentOrdinalsCondition";

    public ValidationResult<Taxonomy> validate(RosettaPath var1, Taxonomy var2);

    public static class NoOp
    implements TaxonomyDifferentOrdinals {
        @Override
        public ValidationResult<Taxonomy> validate(RosettaPath path, Taxonomy taxonomy) {
            return ValidationResult.success((String)TaxonomyDifferentOrdinals.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Taxonomy", (RosettaPath)path, (String)TaxonomyDifferentOrdinals.DEFINITION);
        }
    }

    public static class Default
    implements TaxonomyDifferentOrdinals {
        @Inject
        protected DifferentOrdinalsCondition differentOrdinalsCondition;

        @Override
        public ValidationResult<Taxonomy> validate(RosettaPath path, Taxonomy taxonomy) {
            ComparisonResult result = this.executeDataRule(taxonomy);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TaxonomyDifferentOrdinals.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Taxonomy", (RosettaPath)path, (String)TaxonomyDifferentOrdinals.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TaxonomyDifferentOrdinals failed.";
            }
            return ValidationResult.failure((String)TaxonomyDifferentOrdinals.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Taxonomy", (RosettaPath)path, (String)TaxonomyDifferentOrdinals.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Taxonomy taxonomy) {
            try {
                ComparisonResult result = ComparisonResult.of((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)taxonomy).map("getValue", _taxonomy -> _taxonomy.getValue()).mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification()).map("getOrdinal", taxonomyClassification -> taxonomyClassification.getOrdinal())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)this.differentOrdinalsCondition.evaluate((Taxonomy)MapperS.of((Object)taxonomy).get()));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

