/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.CollateralTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="CollateralTaxonomyUsEligibleCollateralTaxonomy")
@ImplementedBy(value=Default.class)
public interface CollateralTaxonomyUsEligibleCollateralTaxonomy
extends Validator<CollateralTaxonomy> {
    public static final String NAME = "CollateralTaxonomyUsEligibleCollateralTaxonomy";
    public static final String DEFINITION = "if taxonomySource = TaxonomySourceEnum -> US_CFTC_PR_EligibleCollateralAssetClass then taxonomyValue -> us_CFTC_PR_EligibleCollateral exists";

    public ValidationResult<CollateralTaxonomy> validate(RosettaPath var1, CollateralTaxonomy var2);

    public static class NoOp
    implements CollateralTaxonomyUsEligibleCollateralTaxonomy {
        @Override
        public ValidationResult<CollateralTaxonomy> validate(RosettaPath path, CollateralTaxonomy collateralTaxonomy) {
            return ValidationResult.success((String)CollateralTaxonomyUsEligibleCollateralTaxonomy.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralTaxonomy", (RosettaPath)path, (String)CollateralTaxonomyUsEligibleCollateralTaxonomy.DEFINITION);
        }
    }

    public static class Default
    implements CollateralTaxonomyUsEligibleCollateralTaxonomy {
        @Override
        public ValidationResult<CollateralTaxonomy> validate(RosettaPath path, CollateralTaxonomy collateralTaxonomy) {
            ComparisonResult result = this.executeDataRule(collateralTaxonomy);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)CollateralTaxonomyUsEligibleCollateralTaxonomy.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralTaxonomy", (RosettaPath)path, (String)CollateralTaxonomyUsEligibleCollateralTaxonomy.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition CollateralTaxonomyUsEligibleCollateralTaxonomy failed.";
            }
            return ValidationResult.failure((String)CollateralTaxonomyUsEligibleCollateralTaxonomy.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralTaxonomy", (RosettaPath)path, (String)CollateralTaxonomyUsEligibleCollateralTaxonomy.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(CollateralTaxonomy collateralTaxonomy) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)collateralTaxonomy).map("getTaxonomySource", _collateralTaxonomy -> _collateralTaxonomy.getTaxonomySource()), (Mapper)MapperS.of((Object)((Object)TaxonomySourceEnum.US_CFTC_PR_ELIGIBLE_COLLATERAL_ASSET_CLASS)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)collateralTaxonomy).map("getTaxonomyValue", _collateralTaxonomy -> _collateralTaxonomy.getTaxonomyValue()).mapC("getUs_CFTC_PR_EligibleCollateral", collateralTaxonomyValue -> collateralTaxonomyValue.getUs_CFTC_PR_EligibleCollateral()));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

