/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="MaturityTypeEnum")
public enum MaturityTypeEnum {
    REMAINING_MATURITY("RemainingMaturity"),
    ORIGINAL_MATURITY("OriginalMaturity"),
    FROM_ISSUANCE("FromIssuance");

    private static Map<String, MaturityTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private MaturityTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private MaturityTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static MaturityTypeEnum fromDisplayName(String name) {
        MaturityTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, MaturityTypeEnum> map = new ConcurrentHashMap<String, MaturityTypeEnum>();
        for (MaturityTypeEnum instance : MaturityTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

