/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.validation.datarule;

import cdm.base.math.Quantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="QuantityAmountOnlyExists")
@ImplementedBy(value=Default.class)
public interface QuantityAmountOnlyExists
extends Validator<Quantity> {
    public static final String NAME = "QuantityAmountOnlyExists";
    public static final String DEFINITION = "value exists and datedValue is absent";

    public ValidationResult<Quantity> validate(RosettaPath var1, Quantity var2);

    public static class NoOp
    implements QuantityAmountOnlyExists {
        @Override
        public ValidationResult<Quantity> validate(RosettaPath path, Quantity quantity) {
            return ValidationResult.success((String)QuantityAmountOnlyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Quantity", (RosettaPath)path, (String)QuantityAmountOnlyExists.DEFINITION);
        }
    }

    public static class Default
    implements QuantityAmountOnlyExists {
        @Override
        public ValidationResult<Quantity> validate(RosettaPath path, Quantity quantity) {
            ComparisonResult result = this.executeDataRule(quantity);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)QuantityAmountOnlyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Quantity", (RosettaPath)path, (String)QuantityAmountOnlyExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition QuantityAmountOnlyExists failed.";
            }
            return ValidationResult.failure((String)QuantityAmountOnlyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Quantity", (RosettaPath)path, (String)QuantityAmountOnlyExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Quantity quantity) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)quantity).map("getValue", measureBase -> measureBase.getValue())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)quantity).mapC("getDatedValue", measureSchedule -> measureSchedule.getDatedValue())));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

