/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.daycount.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.functions.DateDifference;
import cdm.base.datetime.functions.LeapYearDateDifference;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.IsLeapYear;
import com.rosetta.model.lib.functions.Min;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import javax.inject.Inject;

public class YearFraction
implements RosettaFunction {
    @Inject
    protected YearFraction_1_1 yearFraction_1_1;
    @Inject
    protected YearFractionACT_ACT_ISDA yearFractionACT_ACT_ISDA;
    @Inject
    protected YearFractionACT_ACT_ICMA yearFractionACT_ACT_ICMA;
    @Inject
    protected YearFractionACT_365_FIXED yearFractionACT_365_FIXED;
    @Inject
    protected YearFractionACT_360 yearFractionACT_360;
    @Inject
    protected YearFraction_30_360 yearFraction_30_360;
    @Inject
    protected YearFraction_30E_360 yearFraction_30E_360;
    @Inject
    protected YearFraction_30E_360_ISDA yearFraction_30E_360_ISDA;
    @Inject
    protected YearFractionACT_364 yearFractionACT_364;
    @Inject
    protected YearFractionACT_365L yearFractionACT_365L;
    @Inject
    protected YearFractionCAL_252 yearFractionCAL_252;

    public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
        switch (dayCountFractionEnum) {
            case _1_1: {
                return this.yearFraction_1_1.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_ACT_ISDA: {
                return this.yearFractionACT_ACT_ISDA.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_ACT_ICMA: {
                return this.yearFractionACT_ACT_ICMA.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_365_FIXED: {
                return this.yearFractionACT_365_FIXED.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_360: {
                return this.yearFractionACT_360.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case _30_360: {
                return this.yearFraction_30_360.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case _30E_360: {
                return this.yearFraction_30E_360.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case _30E_360_ISDA: {
                return this.yearFraction_30E_360_ISDA.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_364: {
                return this.yearFractionACT_364.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_365L: {
                return this.yearFractionACT_365L.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case CAL_252: {
                return this.yearFractionCAL_252.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
        }
        throw new IllegalArgumentException("Enum value not implemented: " + (Object)((Object)dayCountFractionEnum));
    }

    @ImplementedBy(value=YearFractionCAL_252Default.class)
    public static abstract class YearFractionCAL_252
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFractionCAL_252Default
        extends YearFractionCAL_252 {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)252)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=YearFractionACT_365LDefault.class)
    public static abstract class YearFractionACT_365L
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Boolean> endDateIsInLeapYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFractionACT_365LDefault
        extends YearFractionACT_365L {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.daysInYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get()))).get();
                return result;
            }

            @Override
            protected Mapper<Boolean> endDateIsInLeapYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new IsLeapYear().execute((Integer)MapperS.of((Object)endDate).map("Year", Date::getYear).get()));
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }

            @Override
            protected Mapper<Integer> daysInYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.endDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)366);
                    }
                    return MapperS.of((Object)365);
                });
            }
        }
    }

    @ImplementedBy(value=YearFractionACT_364Default.class)
    public static abstract class YearFractionACT_364
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFractionACT_364Default
        extends YearFractionACT_364 {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)364)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=YearFraction_30E_360_ISDADefault.class)
    public static abstract class YearFraction_30E_360_ISDA
    implements RosettaFunction {
        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Boolean> startDateIsInLeapYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Boolean> endDateIsInLeapYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFraction_30E_360_ISDADefault
        extends YearFraction_30E_360_ISDA {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperMaths.add((Mapper)MapperMaths.add((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)360), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)30), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get()))))), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperS.of((Object)360)).get();
                return result;
            }

            @Override
            protected Mapper<Boolean> startDateIsInLeapYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new IsLeapYear().execute((Integer)MapperS.of((Object)startDate).map("Year", Date::getYear).get()));
            }

            @Override
            protected Mapper<Boolean> endDateIsInLeapYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new IsLeapYear().execute((Integer)MapperS.of((Object)endDate).map("Year", Date::getYear).get()));
            }

            @Override
            protected Mapper<Integer> startYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> endYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> startMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> startDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.startDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Month", Date::getMonth), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)28), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.startDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Month", Date::getMonth), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)29), (CardinalityOperator)CardinalityOperator.All))).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)31), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)30);
                    }
                    return MapperS.of((Object)endDate).map("Day", Date::getDay);
                });
            }

            @Override
            protected Mapper<Integer> endDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.endDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Month", Date::getMonth), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)28), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.endDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Month", Date::getMonth), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)29), (CardinalityOperator)CardinalityOperator.All))).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)31), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate), (Mapper)MapperS.of((Object)terminationDate), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)30);
                    }
                    return MapperS.of((Object)endDate).map("Day", Date::getDay);
                });
            }
        }
    }

    @ImplementedBy(value=YearFraction_30E_360Default.class)
    public static abstract class YearFraction_30E_360
    implements RosettaFunction {
        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFraction_30E_360Default
        extends YearFraction_30E_360 {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperMaths.add((Mapper)MapperMaths.add((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)360), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)30), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get()))))), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperS.of((Object)360)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> startYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> endYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> startMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new Min().execute((Integer)MapperS.of((Object)endDate).map("Day", Date::getDay).get(), (Integer)MapperS.of((Object)30).get()));
            }

            @Override
            protected Mapper<Integer> startDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new Min().execute((Integer)MapperS.of((Object)startDate).map("Day", Date::getDay).get(), (Integer)MapperS.of((Object)30).get()));
            }
        }
    }

    @ImplementedBy(value=YearFraction_30_360Default.class)
    public static abstract class YearFraction_30_360
    implements RosettaFunction {
        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFraction_30_360Default
        extends YearFraction_30_360 {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperMaths.add((Mapper)MapperMaths.add((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)360), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)30), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get()))))), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperS.of((Object)360)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> startYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> endYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> startMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)startDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)29), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)new Min().execute((Integer)MapperS.of((Object)endDate).map("Day", Date::getDay).get(), (Integer)MapperS.of((Object)30).get()));
                    }
                    return MapperS.of((Object)endDate).map("Day", Date::getDay);
                });
            }

            @Override
            protected Mapper<Integer> startDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new Min().execute((Integer)MapperS.of((Object)startDate).map("Day", Date::getDay).get(), (Integer)MapperS.of((Object)30).get()));
            }
        }
    }

    @ImplementedBy(value=YearFractionACT_360Default.class)
    public static abstract class YearFractionACT_360
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFractionACT_360Default
        extends YearFractionACT_360 {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)360)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=YearFractionACT_365_FIXEDDefault.class)
    public static abstract class YearFractionACT_365_FIXED
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFractionACT_365_FIXEDDefault
        extends YearFractionACT_365_FIXED {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)365)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=YearFractionACT_ACT_ICMADefault.class)
    public static abstract class YearFractionACT_ACT_ICMA
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFractionACT_ACT_ICMADefault
        extends YearFractionACT_ACT_ICMA {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)periodsInYear))).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=YearFractionACT_ACT_ISDADefault.class)
    public static abstract class YearFractionACT_ACT_ISDA
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;
        @Inject
        protected LeapYearDateDifference leapYearDateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInLeapYearPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInNonLeapPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFractionACT_ACT_ISDADefault
        extends YearFractionACT_ACT_ISDA {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.add((Mapper)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInNonLeapPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)365)), (Mapper)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInLeapYearPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)366))).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }

            @Override
            protected Mapper<Integer> daysInLeapYearPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.leapYearDateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }

            @Override
            protected Mapper<Integer> daysInNonLeapPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.daysInLeapYearPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())));
            }
        }
    }

    @ImplementedBy(value=YearFraction_1_1Default.class)
    public static abstract class YearFraction_1_1
    implements RosettaFunction {
        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class YearFraction_1_1Default
        extends YearFraction_1_1 {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperS.of((Object)new BigDecimal("1.0")).get();
                return result;
            }
        }
    }
}

