/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="TimeUnitEnum")
public enum TimeUnitEnum {
    SECOND("Second"),
    MINUTE("Minute"),
    HOUR("Hour"),
    DAY("Day"),
    WEEK("Week"),
    MONTH("Month"),
    YEAR("Year");

    private static Map<String, TimeUnitEnum> values;
    private final String rosettaName;
    private final String displayName;

    private TimeUnitEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private TimeUnitEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static TimeUnitEnum fromDisplayName(String name) {
        TimeUnitEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, TimeUnitEnum> map = new ConcurrentHashMap<String, TimeUnitEnum>();
        for (TimeUnitEnum instance : TimeUnitEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

