# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['ForwardPayout']

from cdm.product.common.settlement.PayoutBase import PayoutBase

class ForwardPayout(PayoutBase):
  """
  Represents a forward settling payout. The underlier attribute captures the underlying payout, which is settled according to the settlementTerms attribute (which is part of PayoutBase). Both FX Spot and FX Forward should use this component.
  """
  underlier: Product = Field(..., description="Underlying product that the forward is written on, which can be of any type: FX, a contractual product, a security, etc.")
  """
  Underlying product that the forward is written on, which can be of any type: FX, a contractual product, a security, etc.
  """
  deliveryTerm: Optional[str] = Field(None, description="Also called contract month or delivery month. However, it's not always a month. It is usually expressed using a code, e.g. Z23 would be the Dec 2023 contract, (Z = December). For crude oil, the corresponding contract might be called CLZ23.")
  """
  Also called contract month or delivery month. However, it's not always a month. It is usually expressed using a code, e.g. Z23 would be the Dec 2023 contract, (Z = December). For crude oil, the corresponding contract might be called CLZ23.
  """
  delivery: Optional[AssetDeliveryInformation] = Field(None, description="Contains the information relative to the delivery of the asset.")
  """
  Contains the information relative to the delivery of the asset.
  """
  schedule: Optional[CalculationSchedule] = Field(None, description="Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.")
  """
  Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
  """
  
  @rosetta_condition
  def condition_0_SettlementTerms(self):
    """
    For foreign exchange contracts, the settlement terms must exist.
    """
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "settlementTerms")) is not None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "foreignExchange")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_1_SettlementDate(self):
    """
    For foreign exchange contracts, either the settlementDate is set or the cashflowDates, but not both. When the cashflowDates are set, they must be the same for the 2 legs of the currency pair.
    """
    def _then_fn0():
      return (((((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "settlementTerms"), "settlementDate"), "valueDate")) is not None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "foreignExchange"), "exchangedCurrency1"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate")) is None)) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "foreignExchange"), "exchangedCurrency2"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate")) is None)) or (((((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "settlementTerms"), "settlementDate"), "valueDate")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "foreignExchange"), "exchangedCurrency1"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate")) is not None)) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "foreignExchange"), "exchangedCurrency2"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate")) is not None)) and all_elements(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "foreignExchange"), "exchangedCurrency1"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), "=", _resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "foreignExchange"), "exchangedCurrency2"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"))))
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "foreignExchange")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_2_FxSettlement(self):
    """
    For foreign exchange contracts, the settlement type must be either fx non-deliverable settlement or not specified, which implies physical settlement in the case of foreign exchange.
    """
    def _then_fn0():
      return ((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "settlementTerms"), "physicalSettlementTerms")) is None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "foreignExchange")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_3_DeliveryCapacity(self):
    """
    Checks that only one of the representations of delivery capacity is present simultaneously.
    """
    def _then_fn3():
      return ((((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "deliveryCapacity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")) is None)) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")) is None))
    
    def _else_fn3():
      return True
    
    def _then_fn2():
      return (((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")) is None))
    
    def _else_fn2():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")) is not None), _then_fn3, _else_fn3)
    
    def _then_fn1():
      return ((((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "deliveryCapacity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")) is None)) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")) is None))
    
    def _else_fn1():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")) is not None), _then_fn2, _else_fn2)
    
    def _then_fn0():
      return ((((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")) is None)) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")) is None))
    
    def _else_fn0():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")) is not None), _then_fn1, _else_fn1)
    
    return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "deliveryCapacity")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_4_PriceTimeIntervalQuantity(self):
    """
    Checks that only one of the representations of price time interval quantity is present simultaneously.
    """
    def _then_fn2():
      return (((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity")) is None))
    
    def _else_fn2():
      return True
    
    def _then_fn1():
      return (((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity")) is None))
    
    def _else_fn1():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity")) is not None), _then_fn2, _else_fn2)
    
    def _then_fn0():
      return (((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity")) is None))
    
    def _else_fn0():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity")) is not None), _then_fn1, _else_fn1)
    
    return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity")) is not None), _then_fn0, _else_fn0)

from cdm.product.template.Product import Product
from cdm.product.asset.AssetDeliveryInformation import AssetDeliveryInformation
from cdm.product.template.CalculationSchedule import CalculationSchedule

ForwardPayout.update_forward_refs()
