# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['InitialFixingDate']


class InitialFixingDate(BaseDataClass):
  """
  A CDM class which purpose is to specify the initial fixing date either alongside the FpML interest rate specification as an offset of another date, or alongside the credit derivative specification as an unadjusted date.
  """
  relativeDateOffset: Optional[RelativeDateOffset] = Field(None, description="")
  initialFixingDate: Optional[date] = Field(None, description="")
  
  @rosetta_condition
  def condition_0_(self):
    return self.check_one_of_constraint('relativeDateOffset', 'initialFixingDate', necessity=True)

from cdm.base.datetime.RelativeDateOffset import RelativeDateOffset

InitialFixingDate.update_forward_refs()
