package cdm.product.template.validation.datarule;

import cdm.product.template.MultipleExercise;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.0.0
 */
@RosettaDataRule("MultipleExerciseMinimumNumberOfOptions")
@ImplementedBy(MultipleExerciseMinimumNumberOfOptions.Default.class)
public interface MultipleExerciseMinimumNumberOfOptions extends Validator<MultipleExercise> {
	
	String NAME = "MultipleExerciseMinimumNumberOfOptions";
	String DEFINITION = "if minimumNumberOfOptions exists then minimumNumberOfOptions >= 0";
	
	ValidationResult<MultipleExercise> validate(RosettaPath path, MultipleExercise multipleExercise);
	
	class Default implements MultipleExerciseMinimumNumberOfOptions {
	
		@Override
		public ValidationResult<MultipleExercise> validate(RosettaPath path, MultipleExercise multipleExercise) {
			ComparisonResult result = executeDataRule(multipleExercise);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MultipleExercise", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null) {
				failureMessage = "Condition " + NAME + " failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "MultipleExercise", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(MultipleExercise multipleExercise) {
			try {
				ComparisonResult result = MapperUtils.toComparisonResult(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(multipleExercise).<Integer>map("getMinimumNumberOfOptions", partialExercise -> partialExercise.getMinimumNumberOfOptions())).getOrDefault(false)) {
						return greaterThanEquals(MapperS.of(multipleExercise).<Integer>map("getMinimumNumberOfOptions", partialExercise -> partialExercise.getMinimumNumberOfOptions()), MapperS.of(Integer.valueOf(0)), CardinalityOperator.All);
					}
					else {
						return null;
					}
				}));
				return result.get() == null ? ComparisonResult.success() : result;
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MultipleExerciseMinimumNumberOfOptions {
	
		@Override
		public ValidationResult<MultipleExercise> validate(RosettaPath path, MultipleExercise multipleExercise) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MultipleExercise", path, DEFINITION);
		}
	}
}
