package cdm.product.template.validation;

import cdm.observable.asset.SecurityValuation;
import cdm.product.template.InitialMargin;
import cdm.product.template.RepoDurationEnum;
import cdm.product.template.SecurityLeg;
import cdm.product.template.SecurityPayout;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class SecurityPayoutValidator implements Validator<SecurityPayout> {

	@Override
	public ValidationResult<SecurityPayout> validate(RosettaPath path, SecurityPayout o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("securityLeg", (List<? extends SecurityLeg>) o.getSecurityLeg() == null ? 0 : ((List<? extends SecurityLeg>) o.getSecurityLeg()).size(), 1, 0), 
				checkCardinality("initialMargin", (InitialMargin) o.getInitialMargin() != null ? 1 : 0, 0, 1), 
				checkCardinality("repoDuration", (RepoDurationEnum) o.getRepoDuration() != null ? 1 : 0, 0, 1), 
				checkCardinality("securityValuation", (List<? extends SecurityValuation>) o.getSecurityValuation() == null ? 0 : ((List<? extends SecurityValuation>) o.getSecurityValuation()).size(), 1, 0)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("SecurityPayout", ValidationType.CARDINALITY, "SecurityPayout", path, "", error);
		}
		return success("SecurityPayout", ValidationType.CARDINALITY, "SecurityPayout", path, "");
	}

}
